/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import com.google.common.base.Preconditions;
import com.pau101.fairylights.util.Mth;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public final class AABBBuilder {
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;

    public AABBBuilder() {
    }

    public AABBBuilder(BlockPos pos) {
        Objects.requireNonNull(pos, "pos");
        this.minX = pos.func_177958_n();
        this.maxX = this.minX + 1.0;
        this.minY = pos.func_177956_o();
        this.maxY = this.minY + 1.0;
        this.minZ = pos.func_177952_p();
        this.maxZ = this.minZ + 1.0;
    }

    public AABBBuilder(Vec3d min, Vec3d max) {
        this(Objects.requireNonNull(min, (String)"min").field_72450_a, min.field_72448_b, min.field_72449_c, Objects.requireNonNull(max, (String)"max").field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public AABBBuilder(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public AABBBuilder add(Vec3d point) {
        return this.add(Objects.requireNonNull(point, (String)"point").field_72450_a, point.field_72448_b, point.field_72449_c);
    }

    public AABBBuilder add(Vec3i point) {
        return this.add(Objects.requireNonNull(point, "point").func_177958_n(), point.func_177956_o(), point.func_177952_p());
    }

    public AABBBuilder add(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public AABBBuilder include(Vec3d point) {
        return this.include(Objects.requireNonNull(point, (String)"point").field_72450_a, point.field_72448_b, point.field_72449_c);
    }

    public AABBBuilder include(double x, double y, double z) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        return this;
    }

    public AABBBuilder expand(double amount) {
        this.minX -= amount;
        this.minY -= amount;
        this.minZ -= amount;
        this.maxX += amount;
        this.maxY += amount;
        this.maxZ += amount;
        return this;
    }

    public AxisAlignedBB build() {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public static AxisAlignedBB union(List<AxisAlignedBB> aabbs) {
        Objects.requireNonNull(aabbs, "AABBs");
        return AABBBuilder.union(aabbs, aabb -> aabb);
    }

    public static <T> AxisAlignedBB union(List<T> aabbs, Function<T, AxisAlignedBB> mapper) {
        Objects.requireNonNull(aabbs, "AABBs");
        Objects.requireNonNull(mapper, "mapper");
        Preconditions.checkArgument((aabbs.size() > 0 ? 1 : 0) != 0, (Object)"Must have more than zero AABBs");
        AxisAlignedBB bounds = mapper.apply(aabbs.get(0));
        if (aabbs.size() == 1) {
            return Objects.requireNonNull(bounds, "mapper returned bounds");
        }
        double minX = bounds.field_72340_a;
        double minY = bounds.field_72338_b;
        double minZ = bounds.field_72339_c;
        double maxX = bounds.field_72336_d;
        double maxY = bounds.field_72337_e;
        double maxZ = bounds.field_72334_f;
        int size = aabbs.size();
        for (int i = 1; i < size; ++i) {
            bounds = Objects.requireNonNull(mapper.apply(aabbs.get(i)), "mapper returned bounds");
            minX = Mth.min(minX, bounds.field_72340_a, bounds.field_72336_d);
            minY = Mth.min(minY, bounds.field_72338_b, bounds.field_72337_e);
            minZ = Mth.min(minZ, bounds.field_72339_c, bounds.field_72334_f);
            maxX = Mth.max(maxX, bounds.field_72340_a, bounds.field_72336_d);
            maxY = Mth.max(maxY, bounds.field_72338_b, bounds.field_72337_e);
            maxZ = Mth.max(maxZ, bounds.field_72339_c, bounds.field_72334_f);
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

