/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tamaized.aov.AoV;
import tamaized.aov.client.gui.GuiScreenClose;
import tamaized.aov.client.gui.buttonlist.AstroSkillRegisterButtons;
import tamaized.aov.client.gui.buttonlist.ClericSkillRegisterButtons;
import tamaized.aov.client.gui.buttonlist.DruidSkillRegisterButtons;
import tamaized.aov.client.gui.buttonlist.FavoredSoulSkillRegisterButtons;
import tamaized.aov.client.gui.buttonlist.IClassButtons;
import tamaized.aov.client.gui.buttonlist.PaladinSkillRegisterButtons;
import tamaized.aov.client.gui.buttons.SkillButton;
import tamaized.aov.common.blocks.BlockAngelicBlock;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.gui.GuiHandler;
import tamaized.aov.network.server.ServerPacketHandlerSpellSkill;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class AoVSkillsGUI
extends GuiScreenClose {
    private static final int BUTTON_CLOSE = 0;
    private static final int BUTTON_SKILL_CHECK = 1;
    private static final int BUTTON_SPELLBOOK = 2;
    private static final int BUTTON_RESET = 3;
    private static final int BUTTON_CHECKSTATS = 4;
    private static final int BUTTON_PAGE_PREV = 5;
    private static final int BUTTON_PAGE_NEXT = 6;
    private static List<IClassButtons> CLASS_BUTTON_REGISTRY = Lists.newArrayList((Object[])new IClassButtons[]{new FavoredSoulSkillRegisterButtons(), new ClericSkillRegisterButtons(), new PaladinSkillRegisterButtons(), new AstroSkillRegisterButtons(), new DruidSkillRegisterButtons()});
    private final Container inventory;
    private final BlockAngelicBlock.ClassType classType;
    private int page;
    private List<SkillButton> skillButtonList = new ArrayList<SkillButton>();
    private int lastMx = 0;
    private int lastMy = 0;
    private IAoVCapability cap;

    public AoVSkillsGUI(BlockAngelicBlock.ClassType classType) {
        this.inventory = new GuiHandler.FakeContainer();
        this.classType = classType;
    }

    public static int getSkillButtonID() {
        return 1;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.inventory;
        this.cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)this.field_146297_k.field_71439_g, CapabilityList.AOV, null);
        if (this.cap != null) {
            if (this.classType == BlockAngelicBlock.ClassType.ALL) {
                for (IClassButtons b : CLASS_BUTTON_REGISTRY) {
                    if (!b.active(this.cap)) continue;
                    this.page = CLASS_BUTTON_REGISTRY.indexOf(b);
                    break;
                }
            } else {
                this.page = this.classType.ordinal() - 1;
            }
            this.initButtons();
        } else {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void initButtons() {
        this.field_146292_n.clear();
        this.skillButtonList.clear();
        this.field_146292_n.add(new GuiButton(0, 10, this.field_146295_m - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.close", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, 110, this.field_146295_m - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.spellbook", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l - 190, this.field_146295_m - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.stats", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l - 90, this.field_146295_m - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.reset", (Object[])new Object[0])));
        if (this.classType == BlockAngelicBlock.ClassType.ALL) {
            this.field_146292_n.add(new ArrowButton(5, this.field_146294_l / 2 - 95, 39, 20, this.field_146295_m - 70, "<"));
            this.field_146292_n.add(new ArrowButton(6, this.field_146294_l / 2 + 69, 39, 20, this.field_146295_m - 70, ">"));
        }
        CLASS_BUTTON_REGISTRY.get(MathHelper.func_76125_a((int)this.page, (int)0, (int)(CLASS_BUTTON_REGISTRY.size() - 1))).register(this);
    }

    public void addNewButton(SkillButton button) {
        this.field_146292_n.add(button);
        this.skillButtonList.add(button);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    this.field_146297_k.field_71439_g.func_71053_j();
                    break;
                }
                case 1: {
                    if (!(button instanceof SkillButton)) break;
                    SkillButton skillButton = (SkillButton)button;
                    boolean bl = !this.beginChecks(skillButton);
                    skillButton.field_146124_l = bl;
                    break;
                }
                case 2: {
                    GuiHandler.openGUI(GuiHandler.GUI.SPELLBOOK, this.classType, (EntityPlayer)this.field_146297_k.field_71439_g, (World)this.field_146297_k.field_71441_e);
                    break;
                }
                case 3: {
                    GuiHandler.openGUI(GuiHandler.GUI.RESET, this.classType, (EntityPlayer)this.field_146297_k.field_71439_g, (World)this.field_146297_k.field_71441_e);
                    break;
                }
                case 4: {
                    GuiHandler.openGUI(GuiHandler.GUI.CHECKSTATS, this.classType, (EntityPlayer)this.field_146297_k.field_71439_g, (World)this.field_146297_k.field_71441_e);
                    break;
                }
                case 5: {
                    if (this.page > 0) {
                        --this.page;
                    }
                    this.initButtons();
                    break;
                }
                case 6: {
                    if (this.page < CLASS_BUTTON_REGISTRY.size() - 1) {
                        ++this.page;
                    }
                    this.initButtons();
                    break;
                }
            }
        }
    }

    private boolean beginChecks(SkillButton button) {
        if ((button.getSkill() == null || !this.cap.hasSkill(button.getSkill())) && button.canObtain(this.cap)) {
            AoV.network.sendToServer((IMessage)new ServerPacketHandlerSpellSkill.Packet(ServerPacketHandlerSpellSkill.Packet.PacketType.SKILLEDIT_CHECK_CANOBTAIN, null, button.getSkill().getID()));
        }
        return false;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            if (this.field_146297_k.field_71439_g == null) {
                Minecraft.func_71410_x().func_147108_a(null);
            } else {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiButton button : this.field_146292_n) {
            if (button instanceof SkillButton) {
                ((SkillButton)button).update(this.cap);
            }
            if (button.field_146127_k == 5) {
                boolean bl = button.field_146124_l = this.page > 0;
            }
            if (button.field_146127_k != 6) continue;
            button.field_146124_l = this.page < CLASS_BUTTON_REGISTRY.size() - 1;
        }
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"aov.gui.title.skills", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"aov.gui.skills.points", (Object[])new Object[]{this.cap == null ? "null" : Integer.valueOf(this.cap.getSkillPoints())}), 5, 5, -256);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"aov.gui.skills.spent", (Object[])new Object[]{this.cap == null ? "null" : Integer.valueOf(this.cap.getSpentSkillPoints()), this.cap == null ? "null" : Integer.valueOf(this.cap.getLevel())}), 5, 15, -256);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"aov.gui.skills.level", (Object[])new Object[0]), this.field_146294_l - 40, 5, -256);
        this.func_73731_b(this.field_146289_q, "" + (this.cap == null ? "null" : Integer.valueOf(this.cap.getLevel())), this.field_146294_l - 40, 15, -256);
        AoVSkillsGUI.func_73734_a((int)(this.field_146294_l / 2 - 66), (int)(this.field_146295_m - 215), (int)(this.field_146294_l / 2 - 66 + 126), (int)(this.field_146295_m - 27), (int)-2013265920);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (mouseX != this.lastMx || mouseY != this.lastMy) {
            boolean flag = true;
            for (SkillButton b : this.skillButtonList) {
                if (!b.func_146115_a() || b.getSkill() == null || b.getSkill().getDescription() == null) continue;
                this.func_146283_a(b.getSkill().getDescription(), mouseX, mouseY);
                flag = false;
                break;
            }
            if (flag) {
                this.lastMy = mouseY;
                this.lastMx = mouseX;
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.field_146297_k.field_71439_g != null) {
            this.inventory.func_75134_a((EntityPlayer)this.field_146297_k.field_71439_g);
        }
    }

    static class ArrowButton
    extends GuiButton {
        private static final ResourceLocation TEXTURE = new ResourceLocation("aov", "textures/gui/buttons.png");

        public ArrowButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText) {
            super(buttonId, x, y, widthIn, heightIn, buttonText);
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_181662_b((double)this.field_146128_h, (double)this.field_146129_i, 0.0).func_187315_a((double)((float)i / 3.0f), 0.0).func_181675_d();
                bufferbuilder.func_181662_b((double)this.field_146128_h, (double)(this.field_146129_i + this.field_146121_g), 0.0).func_187315_a((double)((float)i / 3.0f), 1.0).func_181675_d();
                bufferbuilder.func_181662_b((double)(this.field_146128_h + 20), (double)(this.field_146129_i + this.field_146121_g), 0.0).func_187315_a((double)((1.0f + (float)i) / 3.0f), 1.0).func_181675_d();
                bufferbuilder.func_181662_b((double)(this.field_146128_h + 20), (double)this.field_146129_i, 0.0).func_187315_a((double)((1.0f + (float)i) / 3.0f), 0.0).func_181675_d();
                tessellator.func_78381_a();
                this.func_146119_b(mc, mouseX, mouseY);
                int j = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    j = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    j = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    j = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
            }
        }
    }
}

