/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.config.ConfigHandler;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.universal.InvokeMass;
import tamaized.aov.proxy.ClientProxy;

@Mod.EventBusSubscriber(modid="aov", value={Side.CLIENT})
public class AoVUIBar {
    public static final ResourceLocation widgetsTexPath = new ResourceLocation("textures/gui/widgets.png");
    private static final Minecraft mc = Minecraft.func_71410_x();
    public static int slotLoc = 0;

    @SubscribeEvent
    public static void disableHotbar(RenderGameOverlayEvent e) {
        if (ConfigHandler.renderBarOverHotbar && e.getType() == RenderGameOverlayEvent.ElementType.HOTBAR && ClientProxy.barToggle) {
            e.setCanceled(true);
        }
    }

    public static void render(Gui gui, int xpos, int ypos) {
        if (ConfigHandler.renderBarOverHotbar && !ClientProxy.barToggle) {
            return;
        }
        if (AoVUIBar.mc.field_71439_g == null || !AoVUIBar.mc.field_71439_g.hasCapability(CapabilityList.AOV, null)) {
            return;
        }
        IAoVCapability cap = (IAoVCapability)AoVUIBar.mc.field_71439_g.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        GlStateManager.func_179094_E();
        ScaledResolution sr = new ScaledResolution(mc);
        if (ConfigHandler.renderBarOverHotbar) {
            xpos = 0;
            ypos = 0;
            GlStateManager.func_179109_b((float)0.0f, (float)(sr.func_78328_b() - 23), (float)0.0f);
        }
        float alpha = 0.2f;
        if (ClientProxy.barToggle) {
            alpha = 1.0f;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        mc.func_110434_K().func_110577_a(widgetsTexPath);
        int i = sr.func_78326_a() / 2;
        gui.func_73729_b(xpos + i - 91, ypos + 1, 0, 0, 182, 22);
        gui.func_73729_b(xpos + i - 91 - 1 + slotLoc * 20, ypos, 0, 22, 24, 22);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.01f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-20.01f, (float)0.0f, (float)0.0f);
        for (int j = 0; j < 9; ++j) {
            GlStateManager.func_179109_b((float)20.01f, (float)0.0f, (float)0.0f);
            Ability ability = cap.getSlot(j);
            if (ability == null) continue;
            int k = sr.func_78326_a() / 2 - 90 + 2;
            int l = 4;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            AoVUIBar.renderHotbarIcon(gui, cap, j, xpos + k, ypos + l, ability.getAbility().getIcon(), ability.getAbility() instanceof InvokeMass && cap.getInvokeMass());
            if (ability.getCooldown() <= 0) continue;
            AoVUIBar.renderCooldown(gui, AoVUIBar.mc.field_71466_p, xpos + k, ypos + l, ability.getCooldownPerc(), ability.getCooldown());
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    public static void renderHotbarIcon(Gui gui, IAoVCapability cap, int index, int xPos, int yPos, ResourceLocation icon, boolean active) {
        Ability ability;
        if (icon == null) {
            return;
        }
        GlStateManager.func_179094_E();
        float f1 = 0.0625f;
        GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)0.0f);
        GlStateManager.func_179152_a((float)(1.0f * f1), (float)(1.0f * f1), (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        AoVUIBar.renderIcon(gui, icon);
        if (active) {
            Gui.func_73734_a((int)0, (int)0, (int)256, (int)256, (int)0x7700FFFF);
        }
        Ability ability2 = ability = cap == null ? null : cap.getSlot(index);
        if (ability != null && (!ability.canUse(cap) || ability.isOnCooldown(cap) && !ability.getAbility().canUseOnCooldown(cap, (EntityPlayer)AoVUIBar.mc.field_71439_g))) {
            Gui.func_73734_a((int)0, (int)0, (int)256, (int)256, (int)0x77FF0000);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private static void renderIcon(Gui gui, ResourceLocation icon) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
        gui.func_73729_b(0, 0, 0, 0, 256, 256);
    }

    private static void renderCooldown(Gui gui, FontRenderer fr, int xPos, int yPos, float perc, int timeLeft) {
        GlStateManager.func_179094_E();
        float f1 = 0.0625f;
        GlStateManager.func_179109_b((float)xPos, (float)yPos, (float)0.0f);
        GlStateManager.func_179152_a((float)(1.0f * f1), (float)(1.0f * f1), (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)1.0f);
        AoVUIBar.renderRadial(0, 0, perc);
        gui.func_73732_a(fr, String.valueOf(timeLeft), 8, 4, 0xFFFF00);
        GlStateManager.func_179121_F();
    }

    public static void renderRadial(int x, int y, float perc) {
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179132_a((boolean)false);
        int r = 10;
        int centerX = x + 8;
        int centerY = y + 8;
        float a = 0.5f;
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187447_r((int)6);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)a);
        GL11.glVertex2i((int)centerX, (int)centerY);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)a);
        int v = (int)(405.0f * perc);
        int v1 = v > 45 ? -45 : -v;
        int v2 = v > 135 ? -135 : -v;
        int v3 = v > 225 ? -225 : -v;
        int v4 = v > 315 ? -315 : -v;
        int v5 = v > 405 ? -405 : -v;
        double rad = (double)((float)v1 / 180.0f) * Math.PI;
        GL11.glVertex2d((double)((double)centerX + Math.cos(-0.7853981633974483) * (double)r), (double)((double)centerY + Math.sin(rad) * (double)r));
        rad = (double)((float)v2 / 180.0f) * Math.PI;
        if (v > 45) {
            GL11.glVertex2d((double)((double)centerX + Math.cos(rad) * (double)r), (double)((double)centerY + Math.sin(-2.356194490192345) * (double)r));
        }
        rad = (double)((float)v3 / 180.0f) * Math.PI;
        if (v > 135) {
            GL11.glVertex2d((double)((double)centerX + Math.cos(-3.9269908169872414) * (double)r), (double)((double)centerY + Math.sin(rad) * (double)r));
        }
        rad = (double)((float)v4 / 180.0f) * Math.PI;
        if (v > 225) {
            GL11.glVertex2d((double)((double)centerX + Math.cos(rad) * (double)r), (double)((double)centerY + Math.sin(-5.497787143782138) * (double)r));
        }
        rad = (double)((float)v5 / 180.0f) * Math.PI;
        if (v > 315) {
            GL11.glVertex2d((double)((double)centerX + Math.cos(-7.0685834705770345) * (double)r), (double)((double)centerY + Math.sin(rad) * (double)r));
        }
        GL11.glVertex2i((int)centerX, (int)centerY);
        GlStateManager.func_187437_J();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
    }
}

