/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.polymorph;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tamaized.aov.AoV;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.skills.AoVSkills;
import tamaized.aov.common.entity.EntityDruidicWolf;
import tamaized.aov.common.helper.UtilHelper;
import tamaized.aov.network.client.ClientPacketHandlerPolymorphDogAttack;
import tamaized.aov.network.server.ServerPacketHandlerPolymorphDogAttack;
import tamaized.aov.registry.AoVPotions;
import tamaized.tammodized.common.helper.CapabilityHelper;
import tamaized.tammodized.common.particles.ParticleHelper;

public class PolymorphCapabilityHandler
implements IPolymorphCapability {
    private static final Set<StateWrapper> WATER_ELEMENTAL_STATES = ImmutableSet.of((Object)new StateWrapper((Block)Blocks.field_150355_j).matchAnyState(), (Object)new StateWrapper((Block)Blocks.field_150358_i).matchAnyState());
    private static final Set<StateWrapper> FIRE_ELEMENTAL_STATES = ImmutableSet.of((Object)new StateWrapper((Block)Blocks.field_150480_ab).matchAnyState(), (Object)new StateWrapper((Block)Blocks.field_150353_l).matchAnyState(), (Object)new StateWrapper((Block)Blocks.field_150356_k).matchAnyState());
    private static final byte FLAG_BIT_LENGTH = 15;
    private static Field ENTITY_isImmuneToFire;
    List<EntityDruidicWolf> wolves = Lists.newArrayList();
    private boolean unsetter_ENTITY_isImmuneToFire = false;
    private IPolymorphCapability.Morph morph;
    private boolean morphSize = false;
    private int attackCooldown;
    private int initalAttackCooldown;
    private int attackCooldownMax = 100;
    private boolean attacking = false;
    private byte flagBits = 0;
    private int polymorphTicker;

    private static boolean isTeleportFriendlyBlock(World world, Entity entity, int x, int z, int y, int xOffset, int zOffset) {
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        IBlockState iblockstate = world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a(entity) && world.func_175623_d(blockpos.func_177984_a()) && world.func_175623_d(blockpos.func_177981_b(2));
    }

    @Override
    public IPolymorphCapability.Morph getMorph() {
        return this.morph;
    }

    @Override
    public void morph(IPolymorphCapability.Morph type) {
        this.morph = type;
        if (type == IPolymorphCapability.Morph.ArchAngel) {
            this.polymorphTicker = 2400;
        }
    }

    @Override
    public boolean localMorphSize() {
        return this.morphSize;
    }

    @Override
    public void setLocalMorphSize(boolean val) {
        this.morphSize = val;
    }

    @Override
    public float getAttackCooldown() {
        return this.attackCooldown;
    }

    @Override
    public void doAttack(EntityPlayer player) {
        this.doAttack(player, false);
    }

    @Override
    public void doAttack(EntityPlayer player, boolean fromPacket) {
        this.doAttack(player, fromPacket, this.attackCooldownMax);
    }

    @Override
    public void doAttack(EntityPlayer player, boolean fromPacket, int cooldown) {
        if (this.getMorph() != IPolymorphCapability.Morph.Wolf) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            if (fromPacket && player.field_70122_E) {
                this.initalAttackCooldown = this.attackCooldown = cooldown;
                Vec3d lookVector = player.func_70676_i(Minecraft.func_71410_x().func_184121_ak());
                IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.AOV, null);
                Vec3d vel = new Vec3d((double)0.9f * lookVector.field_72450_a, 0.5, (double)0.9f * lookVector.field_72449_c);
                if (cap != null && cap.hasSkill(AoVSkills.druid_core_4) && IAoVCapability.isCentered((EntityLivingBase)player, cap)) {
                    vel = new Vec3d((double)1.8f * lookVector.field_72450_a, (double)0.65f, (double)1.8f * lookVector.field_72449_c);
                }
                player.func_70024_g(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
            } else if (this.attackCooldown <= 0 && player.field_70122_E) {
                AoV.network.sendToServer((IMessage)new ServerPacketHandlerPolymorphDogAttack.Packet());
            }
        } else if (this.attackCooldown <= 0 && player instanceof EntityPlayerMP && player.field_70122_E) {
            this.initalAttackCooldown = this.attackCooldown = cooldown;
            this.attacking = true;
            AoV.network.sendTo((IMessage)new ClientPacketHandlerPolymorphDogAttack.Packet(), (EntityPlayerMP)player);
        }
    }

    @Override
    public float getInitalAttackCooldown() {
        return this.initalAttackCooldown;
    }

    @Override
    public void callWolves(World world, EntityPlayer caster, float damage) {
        this.wolves.removeIf(w -> w.field_70128_L);
        for (EntityDruidicWolf wolf : this.wolves) {
            wolf.func_70691_i(wolf.func_110138_aP());
            wolf.extendLife();
        }
        block1: for (int index = 0; index < 5 - this.wolves.size(); ++index) {
            EntityDruidicWolf wolf;
            wolf = new EntityDruidicWolf(world, caster, damage);
            int x = MathHelper.func_76128_c((double)caster.field_70165_t) - 2;
            int z = MathHelper.func_76128_c((double)caster.field_70161_v) - 2;
            int y = MathHelper.func_76128_c((double)caster.func_174813_aQ().field_72338_b);
            for (int l = wolf.func_70681_au().nextInt(6); l <= 8; ++l) {
                for (int i1 = wolf.func_70681_au().nextInt(6); i1 <= 8; ++i1) {
                    if (!PolymorphCapabilityHandler.isTeleportFriendlyBlock(world, (Entity)wolf, x, z, y, l, i1)) continue;
                    double posx = (float)(x + l) + 0.5f;
                    double posy = y;
                    double posz = (float)(z + i1) + 0.5f;
                    wolf.func_70012_b(posx, posy, posz, wolf.field_70177_z, wolf.field_70125_A);
                    for (int i = 0; i < 25; ++i) {
                        Vec3d result = wolf.func_70676_i(1.0f).func_178785_b(wolf.func_70681_au().nextFloat() * 360.0f).func_178789_a(wolf.func_70681_au().nextFloat() * 360.0f);
                        ParticleHelper.spawnVanillaParticleOnServer((World)world, (EnumParticleTypes)EnumParticleTypes.END_ROD, (double)(wolf.field_70165_t + result.field_72450_a), (double)(wolf.field_70163_u + (double)(wolf.field_70131_O / 2.0f) + result.field_72448_b), (double)(wolf.field_70161_v + result.field_72449_c), (double)0.0, (double)0.0, (double)0.0);
                    }
                    this.wolves.add(wolf);
                    world.func_72838_d((Entity)wolf);
                    world.func_184133_a(null, wolf.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, wolf.func_70681_au().nextFloat() + 0.5f);
                    continue block1;
                }
            }
        }
    }

    @Override
    public void update(EntityPlayer player) {
        IAoVCapability aov;
        if (ENTITY_isImmuneToFire == null) {
            ENTITY_isImmuneToFire = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_70178_ae");
        }
        if (!player.field_70170_p.field_72995_K && this.getMorph() == IPolymorphCapability.Morph.ArchAngel && this.polymorphTicker-- <= 0) {
            this.morph(null);
            player.func_184589_d(AoVPotions.slowFall);
            aov = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.AOV, null);
            if (aov != null) {
                aov.markDirty();
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.attacking && this.attackCooldown < this.attackCooldownMax - 10 && (this.attackCooldown <= 0 || player.field_70122_E)) {
            this.attacking = false;
        }
        if (!player.field_70170_p.field_72995_K && this.getMorph() != null && this.getMorph().requiresCentered && !IAoVCapability.isCentered((EntityLivingBase)player, (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.AOV, null))) {
            this.morph(null);
            aov = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.AOV, null);
            if (aov != null) {
                aov.markDirty();
            }
        }
        if (this.getMorph() == IPolymorphCapability.Morph.Wolf) {
            player.field_184617_aD = 9000;
            UtilHelper.setSize((Entity)player, 0.6f, 0.85f);
            player.eyeHeight = player.field_70131_O * 0.8f;
            this.setLocalMorphSize(true);
            if (this.attacking) {
                aov = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.AOV, null);
                List targets = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_186662_g(0.75));
                for (Entity target : targets) {
                    if (!(target instanceof EntityLivingBase) || !target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 5.0f * (aov == null ? 1.0f : aov.getSpellPower() / 100.0f + 1.0f)) || aov == null) continue;
                    aov.addExp((Entity)player, 10, Abilities.wildshapeWolf);
                }
            }
        } else if (this.localMorphSize()) {
            UtilHelper.setSize((Entity)player, 0.6f, 1.8f);
            player.eyeHeight = player.getDefaultEyeHeight();
            this.setLocalMorphSize(false);
        }
        if (this.getMorph() == IPolymorphCapability.Morph.ArchAngel && !player.field_70170_p.field_72995_K) {
            player.func_70050_g(300);
        }
        if (this.getMorph() == IPolymorphCapability.Morph.WaterElemental || this.getMorph() == IPolymorphCapability.Morph.FireElemental) {
            if (!player.field_70170_p.field_72995_K) {
                ArrayList states = Lists.newArrayList();
                AxisAlignedBB bounding = player.func_174813_aQ();
                for (double x = bounding.field_72340_a; x <= bounding.field_72336_d; x += 0.5) {
                    for (double z = bounding.field_72339_c; z <= bounding.field_72334_f; z += 0.5) {
                        for (double y = bounding.field_72338_b; y <= bounding.field_72337_e; y += 0.5) {
                            IBlockState state = player.field_70170_p.func_180495_p(new BlockPos(x, y, z));
                            if (states.contains(state)) continue;
                            states.add(state);
                        }
                    }
                }
                boolean flag = false;
                for (IBlockState state : states) {
                    if (this.getMorph() == IPolymorphCapability.Morph.WaterElemental) {
                        if (StateWrapper.compare(FIRE_ELEMENTAL_STATES, state)) {
                            player.func_70097_a(DamageSource.field_76366_f, 4.0f);
                        }
                        if (!StateWrapper.compare(WATER_ELEMENTAL_STATES, state)) continue;
                        player.func_70050_g(300);
                        flag = true;
                        break;
                    }
                    if (this.getMorph() != IPolymorphCapability.Morph.FireElemental) continue;
                    if (StateWrapper.compare(WATER_ELEMENTAL_STATES, state)) {
                        player.func_70097_a(DamageSource.field_76366_f, 4.0f);
                    }
                    if (!StateWrapper.compare(FIRE_ELEMENTAL_STATES, state)) continue;
                    flag = true;
                    break;
                }
                if (flag && (player.func_70660_b(MobEffects.field_76428_l) == null || player.field_70173_aa % 60 == 0)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100));
                }
                if (player.field_70173_aa % 120 == 0) {
                    IAoVCapability aov2;
                    int flags = 0;
                    float temp = player.field_70170_p.func_180494_b(player.func_180425_c()).func_180626_a(player.func_180425_c());
                    if (temp <= 0.2f) {
                        if (this.getMorph() == IPolymorphCapability.Morph.WaterElemental) {
                            flags = (byte)(flags | 2);
                        }
                        if (this.getMorph() == IPolymorphCapability.Morph.FireElemental) {
                            flags = (byte)(flags | 1);
                        }
                    } else if (temp >= 1.0f) {
                        if (this.getMorph() == IPolymorphCapability.Morph.WaterElemental) {
                            flags = (byte)(flags | 1);
                        }
                        if (this.getMorph() == IPolymorphCapability.Morph.FireElemental) {
                            flags = (byte)(flags | 2);
                        }
                    }
                    byte oldBits = this.flagBits;
                    if ((flags & 1) == 1) {
                        player.func_70097_a(DamageSource.field_76366_f, 1.0f);
                        this.flagBits = (byte)(this.flagBits | 1);
                        if (this.getMorph() == IPolymorphCapability.Morph.WaterElemental) {
                            this.flagBits = (byte)(this.flagBits & 0xD);
                        } else if (this.getMorph() == IPolymorphCapability.Morph.FireElemental) {
                            this.flagBits = (byte)(this.flagBits | 2);
                        }
                    } else {
                        this.flagBits = (byte)(this.flagBits & 0xE);
                    }
                    if (oldBits != this.flagBits && (aov2 = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.AOV, null)) != null) {
                        aov2.markDirty();
                    }
                    if ((flags & 2) == 2) {
                        player.func_70691_i(1.0f);
                    }
                }
            }
        } else {
            this.flagBits = (byte)(this.flagBits & 0xE);
        }
        try {
            if (this.getMorph() == IPolymorphCapability.Morph.FireElemental && !player.func_70045_F()) {
                ENTITY_isImmuneToFire.setBoolean(player, true);
                this.unsetter_ENTITY_isImmuneToFire = true;
            } else if (this.getMorph() != IPolymorphCapability.Morph.FireElemental && player.func_70045_F() && this.unsetter_ENTITY_isImmuneToFire) {
                ENTITY_isImmuneToFire.setBoolean(player, false);
                this.unsetter_ENTITY_isImmuneToFire = false;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte getFlagBits() {
        return this.flagBits;
    }

    @Override
    public void setFlagBits(byte bits) {
        this.flagBits = bits;
    }

    @Override
    public boolean isFlagBitActive(byte bit) {
        return (this.flagBits & bit) == bit;
    }

    @Override
    public void addFlagBits(byte add) {
        this.flagBits = (byte)(this.flagBits | add);
    }

    @Override
    public void subtractFlagBits(byte sub) {
        this.flagBits = (byte)(this.flagBits & (~sub & 0xF));
    }

    private static class StateWrapper {
        private final Block block;
        private final Set<IBlockState> states;
        private boolean match;

        StateWrapper(Block block) {
            this(block.func_176223_P());
        }

        StateWrapper(IBlockState ... states) {
            this.states = ImmutableSet.copyOf((Object[])states);
            this.block = states[0].func_177230_c();
        }

        public static boolean compare(Set<StateWrapper> set, Object obj) {
            for (StateWrapper wrapper : set) {
                if (!wrapper.equals(obj)) continue;
                return true;
            }
            return false;
        }

        public StateWrapper matchAnyState() {
            this.match = true;
            return this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof IBlockState) {
                if (this.match) {
                    return ((IBlockState)obj).func_177230_c() == this.block;
                }
                return this.states.contains(obj);
            }
            return super.equals(obj);
        }
    }
}

