/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.commands;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.blocks.BlockAngelicBlock;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.AoVCapabilityHandler;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.config.ConfigHandler;
import tamaized.aov.common.gui.GuiHandler;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class CommandAoV
extends CommandBase {
    private static IAoVCapability getCap(Entity e) {
        return (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)e, CapabilityList.AOV, null);
    }

    @Nonnull
    public String func_71517_b() {
        return "aov";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "commands.aov.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length > 0) {
            try {
                SubCommand.valueOf(args[0].toUpperCase(Locale.ROOT)).execute((ICommand)this, server, sender, args);
            }
            catch (IllegalArgumentException e) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        } else {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandAoV.func_71530_a((String[])args, (String[])SubCommand.COMMAND_LIST);
        }
        if (args.length > 1) {
            try {
                String[] argsMoved = Arrays.copyOfRange(args, 1, args.length);
                return SubCommand.valueOf(args[0].toUpperCase(Locale.ROOT)).tabCompletion(server, sender, argsMoved, targetPos);
            }
            catch (Throwable e) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        try {
            return SubCommand.valueOf(args[0].toUpperCase(Locale.ROOT)).isUsernameIndex(args, index);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int func_82362_a() {
        return 3;
    }

    static enum ResetType {
        MINOR,
        MAJOR;

    }

    private static enum SubCommand {
        OPEN{

            @Override
            protected void execute(ICommand command, MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender.func_174793_f() instanceof EntityPlayer) {
                    GuiHandler.openGUI(GuiHandler.GUI.SKILLS, BlockAngelicBlock.ClassType.ALL, (EntityPlayer)sender.func_174793_f(), sender.func_130014_f_());
                }
            }
        }
        ,
        SETLEVEL{

            @Override
            protected void execute(ICommand command, MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (args.length > 1) {
                    IAoVCapability cap;
                    Entity e;
                    int level;
                    try {
                        level = MathHelper.func_76125_a((int)Integer.parseInt(args[1]), (int)0, (int)ConfigHandler.maxlevel);
                    }
                    catch (NumberFormatException e2) {
                        throw new WrongUsageException("commands.aov.error.level", new Object[]{ConfigHandler.maxlevel});
                    }
                    if (args.length > 2) {
                        e = CommandBase.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                        cap = CommandAoV.getCap(e);
                    } else {
                        e = sender.func_174793_f();
                        cap = CommandAoV.getCap(e);
                    }
                    if (cap != null) {
                        cap.reset(true);
                        cap.setExp(AoVCapabilityHandler.getExpForLevel(level));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.aov.success.level", new Object[]{e.func_70005_c_(), level}));
                    }
                    return;
                }
                throw new WrongUsageException("commands.aov.usage.setlevel", new Object[0]);
            }

            @Override
            protected List<String> tabCompletion(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                return args.length == 2 ? this.getPlayersForTabComplete(server) : super.tabCompletion(server, sender, args, targetPos);
            }

            @Override
            protected boolean isUsernameIndex(String[] args, int index) {
                return index == 2;
            }
        }
        ,
        RESET{
            private final String[] TAB_LIST = new String[]{"minor", "full", "cooldown"};

            @Override
            protected void execute(ICommand command, MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Entity entity = args.length > 2 ? CommandBase.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[2]) : sender.func_174793_f();
                IAoVCapability cap = CommandAoV.getCap(entity);
                ResetType type = null;
                if (args.length > 1) {
                    if (args[1].equalsIgnoreCase(this.TAB_LIST[0])) {
                        type = ResetType.MINOR;
                    } else if (args[1].equalsIgnoreCase(this.TAB_LIST[1])) {
                        type = ResetType.MAJOR;
                    } else if (args[1].equalsIgnoreCase(this.TAB_LIST[2])) {
                        if (cap != null && entity instanceof EntityPlayer) {
                            cap.resetCharges((EntityPlayer)entity);
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.aov.success.reset", new Object[0]));
                        return;
                    }
                }
                if (type != null && cap != null) {
                    cap.reset(type == ResetType.MAJOR);
                    IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)entity, CapabilityList.POLYMORPH, null);
                    if (poly != null) {
                        poly.morph(null);
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.aov.success.reset", new Object[0]));
                    return;
                }
                throw new WrongUsageException("commands.aov.usage.reset", new Object[0]);
            }

            @Override
            protected List<String> tabCompletion(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                return args.length == 2 ? this.getPlayersForTabComplete(server) : (args.length == 1 ? CommandBase.func_71530_a((String[])args, (String[])this.TAB_LIST) : Collections.emptyList());
            }

            @Override
            protected boolean isUsernameIndex(String[] args, int index) {
                return index == 2;
            }
        };

        private static final String[] COMMAND_LIST;

        protected abstract void execute(ICommand var1, MinecraftServer var2, ICommandSender var3, String[] var4) throws CommandException;

        protected List<String> tabCompletion(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            return Collections.emptyList();
        }

        protected boolean isUsernameIndex(String[] args, int index) {
            return false;
        }

        protected final List<String> getPlayersForTabComplete(MinecraftServer server) {
            return Lists.newArrayList((Object[])server.func_71213_z());
        }

        static {
            int length = SubCommand.values().length;
            String[] list = new String[length];
            for (SubCommand action : SubCommand.values()) {
                list[action.ordinal()] = action.toString().toLowerCase(Locale.ROOT);
            }
            COMMAND_LIST = list;
        }
    }
}

