/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.config.ConfigHandler;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.Aura;
import tamaized.aov.common.core.abilities.IAura;
import tamaized.tammodized.common.helper.CapabilityHelper;
import tamaized.tammodized.common.helper.RayTraceHelper;

public final class Ability {
    private AbilityBase ability;
    private int nextCooldown = -1;
    private int cooldown;
    private int charges;
    private int decay;
    private int timer = -1;
    private boolean disabled = false;
    private int tick = 0;

    public Ability(AbilityBase ability) {
        this.ability = ability;
    }

    public Ability(AbilityBase ability, IAoVCapability cap, @Nullable IAstroCapability astro) {
        this.ability = ability;
        this.reset(null, cap);
    }

    public static Ability construct(ByteBuf stream) {
        int id = stream.readInt();
        if (id < 0) {
            return null;
        }
        Ability ability = new Ability(AbilityBase.getAbilityFromID(id));
        ability.decode(stream);
        return ability;
    }

    public static Ability construct(IAoVCapability cap, @Nullable IAstroCapability astro, NBTTagCompound nbt) {
        int id = nbt.func_74762_e("id");
        if (id < 0) {
            return null;
        }
        Ability ability = new Ability(AbilityBase.getAbilityFromID(id), cap, astro);
        ability.decode(nbt, cap);
        return ability;
    }

    public void encode(ByteBuf stream) {
        stream.writeInt(this.ability.getID());
        stream.writeInt(this.cooldown);
        stream.writeInt(this.charges);
        stream.writeInt(this.decay);
        stream.writeInt(this.timer);
        stream.writeBoolean(this.disabled);
    }

    public void decode(ByteBuf stream) {
        this.cooldown = stream.readInt();
        this.charges = stream.readInt();
        this.decay = stream.readInt();
        this.timer = stream.readInt();
        this.disabled = stream.readBoolean();
    }

    public NBTTagCompound encode(NBTTagCompound nbt, IAoVCapability cap) {
        nbt.func_74768_a("id", this.ability.getID());
        nbt.func_74768_a("cooldown", this.cooldown);
        nbt.func_74768_a("cooldownfailsafe", cap.getCooldown(this.ability));
        nbt.func_74768_a("charges", this.charges);
        nbt.func_74768_a("decay", this.decay);
        nbt.func_74768_a("timer", this.timer);
        nbt.func_74757_a("disabled", this.disabled);
        return nbt;
    }

    public void decode(NBTTagCompound nbt, IAoVCapability cap) {
        this.cooldown = nbt.func_74762_e("cooldown");
        int cooldownfailsafe = nbt.func_74762_e("cooldownfailsafe");
        if (cooldownfailsafe > 0) {
            cap.setCooldown(this.ability, cooldownfailsafe);
        }
        this.charges = nbt.func_74762_e("charges");
        this.decay = nbt.func_74762_e("decay");
        this.timer = nbt.func_74762_e("timer");
        this.disabled = nbt.func_74767_n("disabled");
    }

    public void reset(EntityPlayer caster, IAoVCapability cap) {
        this.cooldown = cap.getCooldown(this.ability);
        this.nextCooldown = -1;
        this.charges = this.ability.getMaxCharges() < 0 ? -1 : this.ability.getMaxCharges() + cap.getExtraCharges((EntityLivingBase)caster, this);
        this.decay = 0;
        this.timer = -1;
        this.disabled = this.getAbility().shouldDisable(caster, cap);
    }

    public void restoreCharge(EntityLivingBase caster, IAoVCapability cap, int amount) {
        this.charges += this.ability.getMaxCharges() > -1 && this.charges < this.ability.getMaxCharges() + cap.getExtraCharges(caster, this) ? amount : 0;
    }

    public void setNextCooldown(int cd) {
        this.nextCooldown = cd;
    }

    public void setTimer(int t) {
        this.timer = t;
    }

    public final void cast(EntityPlayer caster) {
        if (this.disabled) {
            return;
        }
        HashSet<EntityPlayer> set = new HashSet<EntityPlayer>();
        set.add(caster);
        RayTraceResult ray = RayTraceHelper.tracePath((World)caster.field_70170_p, (EntityPlayer)caster, (int)((int)this.getAbility().getMaxDistance()), (float)1.0f, set);
        this.cast(caster, ray == null || !(ray.field_72308_g instanceof EntityLivingBase) ? null : (EntityLivingBase)ray.field_72308_g);
    }

    public void cast(EntityPlayer caster, EntityLivingBase target) {
        if (this.disabled) {
            return;
        }
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.AOV, null);
        if (cap != null) {
            if (target != null && !this.ability.isCastOnTarget(caster, cap, target)) {
                target = null;
            }
            if (cap.canUseAbility(this) && (this.ability.usesInvoke() && cap.getInvokeMass() || target == null || this.ability.getMaxDistance() >= (double)caster.func_70032_d((Entity)target))) {
                if (!this.isOnCooldown(cap)) {
                    if (this.ability.cast(this, caster, target)) {
                        this.charges -= caster.func_184812_l_() ? 0 : this.ability.getCost(cap);
                        this.cooldown = (this.nextCooldown < 0 ? this.ability.getCoolDown() : this.nextCooldown) * (this.ability.usesInvoke() && cap.getInvokeMass() ? 2 : 1);
                    } else {
                        this.cooldown = 1;
                    }
                    cap.setCooldown(this.ability, this.cooldown);
                    this.nextCooldown = -1;
                } else if (this.ability.canUseOnCooldown(cap, caster)) {
                    this.ability.onCooldownCast(this, caster, target, this.cooldown);
                }
            }
        }
    }

    public void castAsAura(Aura aura, EntityPlayer caster, IAoVCapability cap, int life) {
        if (this.disabled) {
            aura.kill();
        } else if (this.ability instanceof IAura) {
            ((IAura)((Object)this.ability)).castAsAura(caster, cap, life);
        }
    }

    public boolean canUse(IAoVCapability cap) {
        return !this.disabled && (this.charges == -1 || this.charges >= this.ability.getCost(cap)) && cap.slotsContain(this.getAbility());
    }

    public boolean isOnCooldown(IAoVCapability cap) {
        return this.cooldown > 0 && cap.getCooldown(this.ability) > 0;
    }

    public AbilityBase getAbility() {
        return this.ability;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public float getCooldownPerc() {
        return (float)this.cooldown / (float)this.ability.getCoolDown();
    }

    public int getCharges() {
        return this.charges;
    }

    public int getDecay() {
        return this.decay;
    }

    public void update(EntityPlayer caster, IAoVCapability cap) {
        ++this.tick;
        this.disabled = this.ability.shouldDisable(caster, cap);
        if (this.tick % 20 == 0 && this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.decay > 0 && this.tick % 400 == 0) {
            --this.decay;
        }
        if (this.ability.getMaxCharges() >= 0 && ConfigHandler.recharge >= 0 && this.charges < this.ability.getMaxCharges() + cap.getExtraCharges((EntityLivingBase)caster, this) && this.tick % ConfigHandler.recharge == 0) {
            ++this.charges;
        }
        if (this.tick % 20 == 0 && this.timer > 0) {
            --this.timer;
        } else if (this.timer == 0) {
            --this.timer;
            this.cooldown = (this.nextCooldown < 0 ? this.ability.getCoolDown() : this.nextCooldown) * (this.ability.usesInvoke() && cap.getInvokeMass() ? 2 : 1);
            cap.setCooldown(this.ability, this.cooldown);
            this.nextCooldown = -1;
            cap.markDirty();
        }
    }

    public boolean compare(Ability check) {
        return check != null && this.ability == check.ability;
    }
}

