/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.IAura;

public final class Aura {
    private Ability spell;
    private int life;

    public Aura(Ability ability, int duration) {
        this.spell = ability;
        this.life = duration * 20;
    }

    public static Aura construct(ByteBuf stream) {
        return new Aura(Ability.construct(stream), stream.readInt());
    }

    public void encode(ByteBuf stream) {
        this.spell.encode(stream);
        stream.writeInt(this.life);
    }

    public final void update(@Nullable EntityPlayer caster) {
        if (caster == null || caster.field_70128_L || !caster.hasCapability(CapabilityList.AOV, null)) {
            this.life = 0;
        }
        if (this.life > 0) {
            this.spell.castAsAura(this, caster, (IAoVCapability)caster.getCapability(CapabilityList.AOV, null), this.life);
        }
        --this.life;
    }

    public final boolean isDead() {
        return this.life <= 0;
    }

    public final void kill() {
        this.life = 0;
    }

    public Ability getSpell() {
        return this.spell;
    }

    public IAura getAsAura() {
        return this.spell.getAbility() instanceof IAura ? (IAura)((Object)this.spell.getAbility()) : null;
    }

    public boolean equals(Object obj) {
        return obj instanceof Aura && ((Aura)obj).getSpell().compare(this.getSpell());
    }
}

