/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntityEarthquake;
import tamaized.aov.common.helper.UtilHelper;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class Earthquake
extends AbilityBase {
    private static final String UNLOC = "aov.spells.earthquake";
    private static final float DAMAGE = 1.0f;
    private static final int RANGE = 20;
    private static final int CHARGES = 3;
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/earthquake.png");

    public Earthquake() {
        super(new TextComponentTranslation(UNLOC.concat(".name"), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{3}), new TextComponentTranslation("aov.spells.global.range", new Object[]{20}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{Float.valueOf(1.0f)}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 3;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 20.0;
    }

    @Override
    public int getCoolDown() {
        return 15;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return IAoVCapability.selectiveTarget((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.AOV, null);
        if (cap == null) {
            return false;
        }
        float damage = 1.0f * (1.0f + cap.getSpellPower() / 100.0f);
        EntityEarthquake quake = new EntityEarthquake(caster.field_70170_p, (Entity)caster, damage);
        Vec3d pos = UtilHelper.getSpellLocation(caster, 20, (Entity)target);
        quake.func_70107_b(pos.field_72450_a + 0.5, pos.field_72448_b + 1.0, pos.field_72449_c + 0.5);
        caster.field_70170_p.func_72838_d((Entity)quake);
        return true;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }
}

