/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellAoVParticles;
import tamaized.aov.proxy.CommonProxy;
import tamaized.aov.registry.AoVPotions;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class NaturesBounty
extends AbilityBase {
    private static final String UNLOC = "aov.spells.naturesbounty";
    private static final int CHARGES = 5;
    private static final float RANGE = 10.0f;
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/naturesbounty.png");

    public NaturesBounty() {
        super(new TextComponentTranslation(UNLOC.concat(".name"), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{5}), new TextComponentTranslation("aov.spells.global.range", new Object[]{Float.valueOf(10.0f)}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public int getExtraCharges(EntityLivingBase entity, IAoVCapability cap) {
        return IAoVCapability.isImprovedCentered(entity, cap) ? this.getMaxCharges() : super.getExtraCharges(entity, cap);
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public int getCoolDown() {
        return 45;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        if (target != null) {
            this.addPotionEffects(target);
        } else {
            this.addPotionEffects((EntityLivingBase)caster);
        }
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.AOV, null);
        if (cap != null) {
            cap.addExp((Entity)caster, 15, this);
        }
        return true;
    }

    private void addPotionEffects(EntityLivingBase entity) {
        entity.func_70690_d(new PotionEffect(AoVPotions.naturesBounty, 18000));
        entity.field_70170_p.func_72838_d((Entity)new EntitySpellAoVParticles(entity.field_70170_p, (Entity)entity, CommonProxy.ParticleType.Heart, 0xFFAAFF, 1));
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_193789_dh, SoundCategory.PLAYERS, 1.0f, entity.func_70681_au().nextFloat() * 0.5f + 0.75f);
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }
}

