/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.registry.AoVPotions;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class Polymorph
extends AbilityBase {
    private final ResourceLocation icon;
    private String name;
    private IPolymorphCapability.Morph type;

    public Polymorph(String name, IPolymorphCapability.Morph type) {
        TextComponentTranslation[] textComponentTranslationArray = new TextComponentTranslation[3];
        name = "aov.spells.polymorph.".concat(name);
        textComponentTranslationArray[0] = new TextComponentTranslation(name.concat(".name"), new Object[0]);
        textComponentTranslationArray[1] = new TextComponentTranslation("", new Object[0]);
        textComponentTranslationArray[2] = new TextComponentTranslation(name.concat(".desc"), new Object[0]);
        super(textComponentTranslationArray);
        this.name = name.concat(".name");
        this.type = type;
        this.icon = new ResourceLocation("aov", "textures/spells/polymorph" + type.name().toLowerCase() + ".png");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 0.0;
    }

    @Override
    public int getCoolDown() {
        return this.type == IPolymorphCapability.Morph.ArchAngel ? 600 : 60;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean shouldDisable(@Nullable EntityPlayer caster, IAoVCapability cap) {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean canUseOnCooldown(IAoVCapability cap, EntityPlayer caster) {
        IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH, null);
        return poly != null && poly.getMorph() == this.type && this.type != IPolymorphCapability.Morph.ArchAngel;
    }

    @Override
    public void onCooldownCast(Ability ability, EntityPlayer caster, EntityLivingBase target, int cooldown) {
        IPolymorphCapability cap = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH, null);
        if (cap != null && cap.getMorph() == this.type) {
            cap.morph(null);
        }
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        boolean cooldown = true;
        IPolymorphCapability cap = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH, null);
        if (cap != null) {
            IAoVCapability aov;
            if (cap.getMorph() != this.type || this.type == IPolymorphCapability.Morph.ArchAngel) {
                cap.morph(this.type);
                if (this.type == IPolymorphCapability.Morph.ArchAngel) {
                    caster.func_70690_d(new PotionEffect(AoVPotions.slowFall, 2400));
                }
            } else {
                cap.morph(null);
                cooldown = false;
            }
            if ((aov = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.AOV, null)) != null) {
                aov.markDirty();
            }
        }
        float pitch = this.type == IPolymorphCapability.Morph.ArchAngel ? caster.func_70681_au().nextFloat() * 0.2f + 0.95f : caster.func_70681_au().nextFloat() * 0.75f + 0.25f;
        caster.field_70170_p.func_184148_a(null, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, this.type.sound, SoundCategory.PLAYERS, this.type == IPolymorphCapability.Morph.ArchAngel ? 1.0f : 0.5f, pitch);
        return cooldown;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }
}

