/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.favoredsoul;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.ProjectileNimbusRay;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class SearingLight
extends AbilityBase {
    private static final int damage = 8;
    private static final int charges = 6;
    private static final int distance = 40;

    public SearingLight() {
        super(new TextComponentTranslation(SearingLight.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{6}), new TextComponentTranslation("aov.spells.global.range", new Object[]{40}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{8}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.searing.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.searing.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/searing.png");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)SearingLight.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 4;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 40.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.AOV, null);
        if (cap == null) {
            return false;
        }
        int a = (int)(8.0f * (1.0f + cap.getSpellPower() / 100.0f));
        ProjectileNimbusRay ray = new ProjectileNimbusRay(caster.field_70170_p, caster, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
        ray.setSpell(this);
        ray.setColor(-1);
        ray.func_70239_b(a);
        ray.setMaxRange(40);
        ray.setSpeed(3);
        caster.field_70170_p.func_72838_d((Entity)ray);
        return true;
    }
}

