/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.events;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.skills.AoVSkills;
import tamaized.aov.registry.AoVPotions;
import tamaized.tammodized.common.helper.CapabilityHelper;
import tamaized.tammodized.common.helper.FloatyTextHelper;

public class AttackHandler {
    private static Set<DamageSource> WATER_SOURCES = ImmutableSet.of((Object)DamageSource.field_76369_e);
    private static Set<DamageSource> FIRE_SOURCES = ImmutableSet.of((Object)DamageSource.field_191552_t, (Object)DamageSource.field_76372_a, (Object)DamageSource.field_76370_b, (Object)DamageSource.field_76371_c, (Object)DamageSource.field_180137_b, (Object)DamageSource.field_190095_e, (Object[])new DamageSource[0]);
    private static boolean livingAttackState = true;

    public static boolean canHurt(Entity entity) {
        return entity instanceof EntityLivingBase && (float)entity.field_70172_ad <= (float)((EntityLivingBase)entity).field_70771_an / 2.0f;
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().func_70660_b(AoVPotions.slowFall) != null) {
            event.setDamageMultiplier(0.0f);
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        Entity attacker = event.getSource().func_76346_g();
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)attacker, CapabilityList.AOV, null);
        if (attacker instanceof EntityLivingBase && cap != null && cap.hasSkill(AoVSkills.druid_core_4) && IAoVCapability.isCentered((EntityLivingBase)attacker, cap)) {
            event.setAmount(event.getAmount() + (float)cap.getLevel());
        }
        if (event.getEntityLiving() != null && event.getEntityLiving().func_70660_b(AoVPotions.shieldOfFaith) != null) {
            event.setAmount(event.getAmount() / 2.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerMeleeAttack(AttackEntityEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH, null);
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.AOV, null);
        if (AttackHandler.canHurt(e.getTarget()) && cap != null && cap.getCoreSkill() == AoVSkills.druid_core_1 && IAoVCapability.isCentered((EntityLivingBase)player, cap)) {
            cap.addExp((Entity)player, 10, Abilities.druidCentered);
        }
        if (poly != null && poly.getMorph() == IPolymorphCapability.Morph.Wolf) {
            float amp = 1.0f + (cap == null ? 0.0f : cap.getSpellPower() / 100.0f);
            float dmg = 4.0f * amp;
            if (poly.isFlagBitActive((byte)8)) {
                dmg += 2.0f * amp * (IAoVCapability.isCentered((EntityLivingBase)e.getEntityPlayer(), cap) ? 2.0f : 1.0f) * (IAoVCapability.isImprovedCentered((EntityLivingBase)player, cap) ? 2.0f : 1.0f);
            }
            poly.subtractFlagBits((byte)8);
            if (poly.isFlagBitActive((byte)4)) {
                dmg += 4.0f * amp * (IAoVCapability.isCentered((EntityLivingBase)e.getEntityPlayer(), cap) ? 2.0f : 1.0f) * (IAoVCapability.isImprovedCentered((EntityLivingBase)player, cap) ? 2.0f : 1.0f);
            }
            poly.subtractFlagBits((byte)4);
            e.getTarget().func_70097_a(DamageSource.func_76365_a((EntityPlayer)e.getEntityPlayer()), dmg);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        IAoVCapability cap;
        Entity attacker = event.getSource().func_76346_g();
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)entity, CapabilityList.POLYMORPH, null);
        if (poly != null) {
            if (poly.getMorph() == IPolymorphCapability.Morph.WaterElemental && WATER_SOURCES.contains(event.getSource()) || poly.getMorph() == IPolymorphCapability.Morph.FireElemental && FIRE_SOURCES.contains(event.getSource())) {
                if (entity.field_70172_ad <= 0) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100));
                    entity.field_70172_ad = 60;
                }
                event.setCanceled(true);
                return;
            }
            if (livingAttackState && poly.getMorph() == IPolymorphCapability.Morph.WaterElemental && FIRE_SOURCES.contains(event.getSource()) || poly.getMorph() == IPolymorphCapability.Morph.FireElemental && WATER_SOURCES.contains(event.getSource())) {
                livingAttackState = false;
                entity.func_70097_a(event.getSource(), event.getAmount() * 2.0f);
                livingAttackState = true;
            }
        }
        if (attacker != null && attacker.hasCapability(CapabilityList.AOV, null)) {
            cap = (IAoVCapability)attacker.getCapability(CapabilityList.AOV, null);
            if (AttackHandler.canHurt((Entity)entity) && cap != null && livingAttackState && attacker.field_70170_p.field_73012_v.nextInt(cap.getDoubleStrikeForRand()) == 0) {
                livingAttackState = false;
                cap.addExp(attacker, 20, Abilities.defenderDoublestrike);
                if (attacker instanceof EntityPlayer) {
                    FloatyTextHelper.sendText((EntityPlayer)((EntityPlayer)attacker), (String)"Doublestrike");
                }
                entity.func_70097_a(event.getSource(), event.getAmount());
                entity.field_70172_ad = 0;
                livingAttackState = true;
            }
            EntityLivingBase attackerLiving = null;
            if (attacker instanceof EntityLivingBase) {
                attackerLiving = (EntityLivingBase)attacker;
            }
            if (cap != null && cap.hasSkill(AoVSkills.paladin_core_3) && attackerLiving != null && (!attackerLiving.func_184614_ca().func_190926_b() && attackerLiving.func_184614_ca().func_77973_b().isShield(attackerLiving.func_184614_ca(), attackerLiving) || !attackerLiving.func_184592_cb().func_190926_b() && attackerLiving.func_184592_cb().func_77973_b().isShield(attackerLiving.func_184592_cb(), attackerLiving))) {
                double d1 = attacker.field_70165_t - entity.field_70165_t;
                double d0 = attacker.field_70161_v - entity.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                entity.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)entity.field_70177_z);
                entity.func_70653_a(attacker, 1.0f, d1, d0);
            }
        }
        if (entity.hasCapability(CapabilityList.AOV, null)) {
            cap = (IAoVCapability)entity.getCapability(CapabilityList.AOV, null);
            if (cap != null && cap.hasSkill(AoVSkills.paladin_core_1) && entity instanceof EntityPlayer && this.canBlockDamageSource((EntityPlayer)entity, event.getSource(), false) && event.getAmount() > 0.0f) {
                cap.addExp((Entity)entity, 20, Abilities.defenderBlocking);
            }
            if (cap != null && this.isWhiteListed(event.getSource()) && cap.getDodge() > 0 && entity.field_70170_p.field_73012_v.nextInt(cap.getDodgeForRand()) == 0) {
                cap.addExp((Entity)entity, 20, Abilities.defenderDodge);
                if (entity instanceof EntityPlayer) {
                    FloatyTextHelper.sendText((EntityPlayer)((EntityPlayer)entity), (String)"Dodged");
                }
                event.setCanceled(true);
                return;
            }
            if (attacker instanceof EntityLivingBase && cap != null && poly != null && poly.getMorph() == IPolymorphCapability.Morph.WaterElemental && cap.isAuraActive(Abilities.elementalEmpowerment)) {
                ((EntityLivingBase)attacker).func_70690_d(new PotionEffect(AoVPotions.coldChill, 400, (int)Math.floor(cap.getSpellPower() / 25.0f)));
                cap.addExp((Entity)entity, 20, Abilities.elementalEmpowerment);
            }
            if (cap != null && cap.hasSkill(AoVSkills.paladin_core_4)) {
                this.handleShield(event, true);
            }
        }
    }

    private void handleShield(LivingAttackEvent e, boolean fullRadial) {
        float damage = e.getAmount();
        if (!(e.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e.getEntityLiving();
        if (this.canBlockDamageSource(player, e.getSource(), fullRadial) && damage > 0.0f) {
            this.damageShield(player, damage);
            e.setCanceled(true);
            ForgeHooks.onLivingHurt((EntityLivingBase)player, (DamageSource)e.getSource(), (float)0.0f);
            if (!e.getSource().func_76352_a()) {
                Entity entity = e.getSource().func_76364_f();
                if (entity instanceof EntityLivingBase) {
                    EntityLivingBase p_190629_1_ = (EntityLivingBase)entity;
                    p_190629_1_.func_70653_a((Entity)player, 0.5f, player.field_70165_t - p_190629_1_.field_70165_t, player.field_70161_v - p_190629_1_.field_70161_v);
                }
                player.field_70170_p.func_72960_a((Entity)player, (byte)29);
            }
        }
    }

    private void damageShield(EntityPlayer player, float damage) {
        if (damage >= 3.0f && !player.func_184607_cu().func_190926_b()) {
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_77972_a(i, (EntityLivingBase)player);
            if (player.func_184607_cu().func_190926_b()) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)player.func_184607_cu(), (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    private boolean canBlockDamageSource(EntityPlayer player, DamageSource damageSourceIn, boolean fullRadial) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && player.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            if (fullRadial) {
                return true;
            }
            Vec3d vec3d1 = player.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            return vec3d2.func_72430_b(vec3d1) < 0.0;
        }
        return false;
    }

    private boolean isWhiteListed(DamageSource source) {
        return source.field_76373_n.equals("generic") || source.field_76373_n.equals("mob") || source.field_76373_n.equals("player") || source.field_76373_n.equals("arrow") || source.field_76373_n.equals("thrown");
    }
}

