/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.gui;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import tamaized.aov.AoV;
import tamaized.aov.client.gui.AoVSkillsGUI;
import tamaized.aov.client.gui.ResetSkillsGUI;
import tamaized.aov.client.gui.ShowStatsGUI;
import tamaized.aov.client.gui.SpellBookGUI;
import tamaized.aov.common.blocks.BlockAngelicBlock;

public class GuiHandler
implements IGuiHandler {
    private static final int GUI_BITS = 15;
    public static final int GUI_BIT_SHIFT = Integer.highestOneBit(15);

    public static void openGUI(GUI gui, BlockAngelicBlock.ClassType classType, @Nonnull EntityPlayer player, @Nonnull World world) {
        BlockPos pos = player.func_180425_c();
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)((Object)AoV.instance), (int)((classType.ordinal() << GUI_BIT_SHIFT) + gui.ordinal()), (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (GUI.values[id & 0xF]) {
            case SKILLS: {
                return new FakeContainer();
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockAngelicBlock.ClassType data = BlockAngelicBlock.ClassType.values[id >>> GUI_BIT_SHIFT];
        switch (GUI.values[id & 0xF]) {
            case SKILLS: {
                return new AoVSkillsGUI(data);
            }
            case SPELLBOOK: {
                return new SpellBookGUI(data);
            }
            case CHECKSTATS: {
                return new ShowStatsGUI(data);
            }
            case RESET: {
                return new ResetSkillsGUI(data);
            }
        }
        return null;
    }

    public static class FakeContainer
    extends Container {
        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
            return true;
        }
    }

    public static enum GUI {
        SKILLS,
        SPELLBOOK,
        CHECKSTATS,
        RESET;

        public static final GUI[] values;

        static {
            values = GUI.values();
        }
    }
}

