/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.registry.ParticleRegistry;

public class ClientPacketHandlerParticle
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, World world) {
        ParticleRegistry.IParticleHandler handler = ParticleRegistry.getHandlerFromID(message.handlerID);
        if (handler != null) {
            handler.execute(Minecraft.func_71410_x().field_71452_i, world, ((Packet)message).pos.field_72450_a, ((Packet)message).pos.field_72448_b, ((Packet)message).pos.field_72449_c, ((Packet)message).vel.field_72450_a, ((Packet)message).vel.field_72448_b, ((Packet)message).vel.field_72449_c, message.data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerParticle.processPacket(message, (World)Minecraft.func_71410_x().field_71441_e));
        return null;
    }

    public static class Packet
    implements IMessage {
        private int handlerID;
        private Vec3d pos;
        private Vec3d vel;
        private int[] data;

        public Packet() {
        }

        public Packet(int id, double x, double y, double z, double dx, double dy, double dz, int ... dat) {
            this.handlerID = id;
            this.pos = new Vec3d(x, y, z);
            this.vel = new Vec3d(dx, dy, dz);
            this.data = dat;
        }

        public void fromBytes(ByteBuf stream) {
            this.handlerID = stream.readInt();
            this.pos = new Vec3d(stream.readDouble(), stream.readDouble(), stream.readDouble());
            this.vel = new Vec3d(stream.readDouble(), stream.readDouble(), stream.readDouble());
            int size = stream.readInt();
            this.data = new int[size];
            for (int i = 0; i < size; ++i) {
                this.data[i] = stream.readInt();
            }
        }

        public void toBytes(ByteBuf stream) {
            stream.writeInt(this.handlerID);
            stream.writeDouble(this.pos.field_72450_a);
            stream.writeDouble(this.pos.field_72448_b);
            stream.writeDouble(this.pos.field_72449_c);
            stream.writeDouble(this.vel.field_72450_a);
            stream.writeDouble(this.vel.field_72448_b);
            stream.writeDouble(this.vel.field_72449_c);
            stream.writeInt(this.data == null ? 0 : this.data.length);
            for (int dat : this.data) {
                stream.writeInt(dat);
            }
        }
    }
}

