/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.helper.ParticleHelper;
import tamaized.aov.proxy.CommonProxy;

public class ClientPacketHandlerParticleMesh
implements IMessageHandler<Packet, IMessage> {
    private static final ParticleHelper.MeshType[] MESH_TYPES = ParticleHelper.MeshType.values();
    private static final CommonProxy.ParticleType[] PARTICLE_TYPES = CommonProxy.ParticleType.values();

    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, EntityPlayer player, World world) {
        ParticleHelper.spawnParticleMesh(message.mesh >= 0 && message.mesh < MESH_TYPES.length ? MESH_TYPES[message.mesh] : ParticleHelper.MeshType.BURST, message.particle >= 0 && message.particle < PARTICLE_TYPES.length ? PARTICLE_TYPES[message.particle] : CommonProxy.ParticleType.Fluff, world, message.pos, message.range, message.color);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerParticleMesh.processPacket(message, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e));
        return null;
    }

    public static class Packet
    implements IMessage {
        private int mesh;
        private int particle;
        private Vec3d pos;
        private int range;
        private int color;

        public Packet() {
        }

        public Packet(ParticleHelper.MeshType mesh, CommonProxy.ParticleType particle, Vec3d pos, int range, int color) {
            this.mesh = mesh.ordinal();
            this.particle = particle.ordinal();
            this.pos = pos;
            this.range = range;
            this.color = color;
        }

        public void fromBytes(ByteBuf buf) {
            this.mesh = buf.readInt();
            this.particle = buf.readInt();
            this.pos = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
            this.range = buf.readInt();
            this.color = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.mesh);
            buf.writeInt(this.particle);
            buf.writeDouble(this.pos.field_72450_a);
            buf.writeDouble(this.pos.field_72448_b);
            buf.writeDouble(this.pos.field_72449_c);
            buf.writeInt(this.range);
            buf.writeInt(this.color);
        }
    }
}

