/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class BlockGrave
extends BlockGraveBase {
    public BlockGrave(GraveModel graveModel) {
        super(graveModel.func_176610_l(), graveModel);
        this.func_149647_a(null);
        this.func_149722_s();
        this.func_149715_a(0.7f);
    }

    @Nullable
    public TileEntityTombstone getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityTombstone ? (TileEntityTombstone)tile : null;
    }

    public TileEntityTombstone createTileEntity(World world, IBlockState state) {
        return new TileEntityTombstone();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return -1.0f;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public String func_149739_a() {
        return "tombstone.grave." + this.name;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.activatePlayerGrave(world, pos, state, player);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity.func_70093_af() && !entity.field_70128_L && TimeHelper.atInterval(entity.field_70173_aa, 20) && EntityHelper.isValidPlayer(entity)) {
            this.activatePlayerGrave(world, pos, state, (EntityPlayer)((EntityPlayerMP)entity));
        }
    }

    private boolean activatePlayerGrave(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        boolean valid;
        if (world.field_72995_K) {
            return true;
        }
        TileEntityTombstone tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile == null || tile.countTicks < 30 || !player.func_70089_S()) {
            return false;
        }
        boolean hasKey = ModItems.grave_key.removeKeyForGraveInInventory(player, new Location(pos, world));
        boolean bl = valid = hasKey || tile.isOwner(player) || !tile.getNeedAccess();
        if (valid) {
            tile.giveInventory(player);
            if (world.func_72912_H().func_176130_y() != EnumDifficulty.PEACEFUL && ConfigTombstone.general.chanceMobOnGraveRecovery > 0 && Helper.getRandom(1, 100) <= ConfigTombstone.general.chanceMobOnGraveRecovery) {
                IntStream.range(0, Helper.getRandom(1, 3)).forEach(i -> this.spawnRandomMob((WorldServer)world, pos));
            }
        } else if (ModItems.grave_key.countKeyInInventory(player) > 0) {
            LangKey.MESSAGE_OPEN_GRAVE_WRONG_KEY.sendWarnMessage((ICommandSender)player, new Object[0]);
        } else {
            LangKey.MESSAGE_OPEN_GRAVE_NEED_KEY.sendWarnMessage((ICommandSender)player, new Object[0]);
        }
        return valid;
    }

    private void spawnRandomMob(WorldServer world, BlockPos pos) {
        EntityZombie mob;
        Location spawnPos = new SpawnHelper(world, new BlockPos(pos.func_177958_n() + Helper.getRandom(-9, 9), pos.func_177956_o(), pos.func_177952_p() + Helper.getRandom(-9, 9))).findSafePlace(2, true, true);
        if (spawnPos.isOrigin()) {
            return;
        }
        try {
            mob = new EntityZombie((World)world);
            mob.func_82227_f(true);
            if (Helper.isDateAroundHalloween((World)world)) {
                mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Blocks.field_150423_aK));
            }
            mob.func_180482_a(world.func_175649_E(new BlockPos((Entity)mob)), null);
            mob.func_70012_b((double)spawnPos.x, (double)spawnPos.y, (double)spawnPos.z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        world.func_72838_d((Entity)mob);
        mob.func_175449_a(pos, 15);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IItemHandler inventory;
        TileEntityTombstone tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            IntStream.range(0, inventory.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inventory).getStackInSlot(arg_0)).filter(stack -> !stack.func_190926_b()).forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
        }
        super.func_180663_b(world, pos, state);
    }
}

