/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;

public class ItemGraveKey
extends ItemGraveMagic {
    public ItemGraveKey() {
        super("grave_key");
        this.func_77637_a(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            String id = this.isEnchanted(stack) ? "2" : "1";
            this.addItemDesc(list, id, new Object[0]);
            Location location = this.getTombPos(stack);
            if (!location.isOrigin()) {
                this.addItemPosition(list, location);
            }
            this.addItemUse(list, id, new Object[0]);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public boolean setTombPos(ItemStack stack, Location location) {
        if (stack.func_77973_b() == this && !location.isOrigin()) {
            NBTStackHelper.setLocation(stack, "tombPos", location);
            return true;
        }
        return false;
    }

    public Location getTombPos(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, "tombPos");
        }
        return Location.ORIGIN;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && EntityHelper.isValidPlayer(entity) && stack.func_77973_b() == this) {
            Location location = this.getTombPos(stack);
            boolean isBadKey = location.isOrigin();
            if (!isBadKey && TimeHelper.atInterval(entity.field_70173_aa, TimeHelper.tickFromMinute(10))) {
                if (!location.isSameDimension(world)) {
                    return;
                }
                if (!world.func_189509_E(location.getPos())) {
                    if (!world.func_175667_e(location.getPos())) {
                        world.func_180495_p(location.getPos());
                    }
                    isBadKey = !(world.func_175625_s(location.getPos()) instanceof TileEntityTombstone);
                } else {
                    isBadKey = true;
                }
            }
            if (isBadKey) {
                stack.func_190918_g(1);
                ((EntityPlayer)entity).field_71069_bz.func_75142_b();
            }
        }
    }

    public ItemStack findFirstKeyInInventory(EntityPlayer player) {
        IItemHandler itemHandler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler != null) {
            return IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == ModItems.grave_key).findFirst().orElse(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    public boolean removeKeyForGraveInInventory(EntityPlayer player, Location graveLoc) {
        IItemHandler itemHandler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_77973_b() != ModItems.grave_key || !ModItems.grave_key.getTombPos(stack).equals(graveLoc)) continue;
                itemHandler.extractItem(i, 1, false);
                return true;
            }
        }
        return false;
    }

    public int countKeyInInventory(EntityPlayer player) {
        return (int)player.field_71071_by.field_70462_a.stream().filter(stack -> stack.func_77973_b() == ModItems.grave_key).count();
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return ConfigTombstone.allowedMagicItems.allowGraveKey;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return true;
        }
        return false;
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_CANT_ENCHANT_GRAVE_KEY.getTranslation(new Object[0]);
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.COMMAND_EXCEPTION_INVALID_LOCATION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        if (!location.isSameDimension(world) && !ConfigTombstone.general.teleportDim) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        assert (player.func_184102_h() != null);
        WorldServer targetWorld = player.func_184102_h().func_71218_a(location.dim);
        if (!Helper.isValidDimension(location.dim) || !Helper.isValidPos((World)targetWorld, location.getPos())) {
            LangKey.COMMAND_EXCEPTION_INVALID_LOCATION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", false);
        CallbackHandler.addCallback(1, () -> {
            EntityPlayer newPlayer = (EntityPlayer)Helper.teleportToGrave(player, location);
            if (ConfigTombstone.general.nerfGhostlyShape) {
                EntityHelper.capPotionDuration((EntityLivingBase)newPlayer, ModEffects.ghostly_shape, 200);
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newPlayer, new Object[0]);
            ModTriggers.TELEPORT_TO_GRAVE.trigger(player);
        });
        return true;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    public void reenchantOnDeath(EntityPlayer player, ItemStack key) {
        int chanceEnchantedKey;
        if (key.func_77973_b() == this && (chanceEnchantedKey = ConfigTombstone.general.getChanceEnchantedGraveKey()) >= 0 && ((chanceEnchantedKey += EntityHelper.getPerkLevelWithBonus(player, ModPerks.grave_key) * 20) >= 100 || chanceEnchantedKey > 0 && Helper.getRandom(1, 100) <= chanceEnchantedKey)) {
            NBTStackHelper.setBoolean(key, "enchant", true);
        }
    }

    @Override
    protected boolean canBlockInteractFirst(IBlockState state, ItemStack stack) {
        return super.canBlockInteractFirst(state, stack) || state.func_177230_c() instanceof BlockGrave;
    }
}

