/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ICustomModel;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLostTablet
extends ItemGraveMagic
implements ICustomModel {
    public ItemLostTablet() {
        super("lost_tablet");
        this.func_77637_a(ModTabs.tabTombstone);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            Location location = this.getStructurePos(stack);
            String id = location.isOrigin() ? "1" : (this.isEnchanted(stack) ? "3" : "2");
            this.addItemDesc(list, id, new Object[0]);
            if (!location.isOrigin()) {
                SupportStructures struct = this.getStructureType(stack);
                if (struct != null) {
                    this.addRawText(list, struct.name().replace("_", " "));
                }
                this.addItemPosition(list, location);
            }
            this.addItemUse(list, id, new Object[0]);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && stack.func_77960_j() == 0) {
            int cd = this.getCooldown(world, stack);
            if (cd <= 0) {
                this.setCooldown(world, stack, TimeHelper.tickFromSecond(Helper.getRandom(500, 800)));
            } else if (cd == 1) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                boolean success = this.wakeUpMagic(player, stack, slotId);
                if (success) {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
                } else if (Helper.getRandom(1, 100) < 50) {
                    this.setCooldown(world, stack, TimeHelper.tickFromSecond(Helper.getRandom(1500, 1800)));
                } else {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
                    stack.func_190918_g(1);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)ItemCraftingIngredient.IconType.GRAVE_DUST.getStack(Helper.getRandom(3, 5)));
                }
                player.field_71069_bz.func_75142_b();
            } else if (TimeHelper.atInterval(entity.field_70173_aa, TimeHelper.tickFromMinute(1)) && ConfigTombstone.general.allowBeyondTheGraveDamage) {
                entity.func_70097_a(ModDamages.BEYOND_THE_GRAVE, 1.0f);
            }
        }
    }

    @Override
    public int getCooldown(@Nullable World world, ItemStack stack) {
        long cd;
        if (world != null && stack.func_77973_b() == this && (cd = NBTStackHelper.getLong(stack, "cooldown_time", 0L)) > 0L) {
            return (int)Math.max(cd - TimeHelper.worldTicks(world), 0L);
        }
        return 0;
    }

    private DimensionType getWorldTypeForStructure(SupportStructures struct) {
        switch (struct) {
            case Fortress: {
                return DimensionType.NETHER;
            }
            case EndCity: {
                return DimensionType.THE_END;
            }
        }
        return DimensionType.OVERWORLD;
    }

    private boolean wakeUpMagic(EntityPlayerMP player, ItemStack stack, int slotId) {
        Location location;
        SupportStructures struct;
        if (Helper.getRandom(1, 100) < 60 - EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.lost_tablet) * 10) {
            struct = SupportStructures.Village;
        } else {
            struct = SupportStructures.getRandomStructure(p -> p != SupportStructures.Village);
            if (struct == null) {
                struct = SupportStructures.Village;
            }
        }
        WorldServer world = player.func_71121_q();
        DimensionType worldType = this.getWorldTypeForStructure(struct);
        if (world.field_73011_w.func_186058_p() != worldType) {
            if (ConfigTombstone.decorativeGrave.allowTabletSearchOutsideWorld) {
                int[] dimensionIds = DimensionManager.getDimensions((DimensionType)worldType);
                if (dimensionIds.length == 0) {
                    return false;
                }
                assert (player.func_184102_h() != null);
                world = player.func_184102_h().func_71218_a(dimensionIds[Helper.getRandom(0, dimensionIds.length - 1)]);
                if (worldType == DimensionType.NETHER) {
                    ((ChunkGeneratorHell)world.func_72863_F().field_186029_c).field_73172_c.func_186125_a((World)world, Integer.MIN_VALUE, Integer.MIN_VALUE, null);
                }
            } else {
                return false;
            }
        }
        if ((location = Helper.findNearestStructure(world, player.func_180425_c(), struct, true)).isOrigin() || !Helper.isValidPos((World)world, location.getPos())) {
            return false;
        }
        boolean isVillage = struct == SupportStructures.Village;
        (isVillage ? ModTriggers.FIND_VILLAGE : ModTriggers.FIND_TREASURE).trigger(player);
        stack.func_77964_b(isVillage ? 1 : 2);
        this.setStructurePos(stack, location);
        this.setStructureType(stack, struct);
        player.field_71069_bz.func_75142_b();
        return true;
    }

    private void setStructureType(ItemStack stack, SupportStructures struct) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setInteger(stack, "structureType", struct.ordinal());
        }
    }

    @Nullable
    public SupportStructures getStructureType(ItemStack stack) {
        if (stack.func_77973_b() == this && NBTStackHelper.hasKeyName(stack, "structureType")) {
            int ordinal = NBTStackHelper.getInteger(stack, "structureType");
            return ordinal < SupportStructures.values().length ? SupportStructures.values()[ordinal] : null;
        }
        return null;
    }

    public boolean isWakeUp(ItemStack stack) {
        return stack.func_77973_b() == this && stack.func_77960_j() > 0;
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return ConfigTombstone.allowedMagicItems.allowLostTablet;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isWakeUp(stack) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (!this.isWakeUp(stack)) {
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", true);
        return true;
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        Location location = this.getStructurePos(stack);
        if (location.isOrigin() || !Helper.isValidDimension(location.dim)) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            this.resetStack(world, stack);
            return false;
        }
        if (!ConfigTombstone.general.teleportDim && !location.isSameDimension(world)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        assert (player.func_184102_h() != null);
        WorldServer targetWorld = player.func_184102_h().func_71218_a(location.dim);
        if (!Helper.isValidPos((World)targetWorld, location.getPos())) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            this.resetStack(world, stack);
            return false;
        }
        Location spawnLoc = Helper.findSpawnForVillage(targetWorld, location.getPos());
        if (spawnLoc.isOrigin()) {
            LangKey.COMMAND_EXCEPTION_NO_SPAWN.sendWarnMessage((ICommandSender)player, new Object[0]);
            this.resetStack(world, stack);
            return false;
        }
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.setLocation(stack, "structurePos", spawnLoc);
        CallbackHandler.addCallback(1, () -> {
            EntityPlayer newPlayer = (EntityPlayer)Helper.teleportEntity(player, spawnLoc);
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newPlayer, new Object[0]);
            ModTriggers.USE_LOST_TABLET.trigger(player);
        });
        return true;
    }

    private void resetStack(World world, ItemStack stack) {
        stack.func_77964_b(0);
        this.setCooldown(world, stack, TimeHelper.tickFromMinute(10));
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.removeKeyName(stack, "structurePosX");
        NBTStackHelper.removeKeyName(stack, "structurePosY");
        NBTStackHelper.removeKeyName(stack, "structurePosZ");
        NBTStackHelper.removeKeyName(stack, "structurePosD");
    }

    public boolean isSameTablet(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == this && stack2.func_77973_b() == this && this.getStructurePos(stack1).equals(this.getStructurePos(stack2));
    }

    public boolean setStructurePos(ItemStack stack, Location location) {
        if (stack.func_77973_b() == this && !location.isOrigin()) {
            NBTStackHelper.setLocation(stack, "structurePos", location);
            return true;
        }
        return false;
    }

    public Location getStructurePos(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            return NBTStackHelper.getLocation(stack, "structurePos");
        }
        return Location.ORIGIN;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    @Override
    public boolean canConsumeOnUse() {
        return false;
    }

    @Override
    public void registerModels() {
        assert (this.getRegistryName() != null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_village", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_treasure", "inventory"));
    }
}

