/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.recipe.RecipeEnchantedGraveKey;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.recipe.RecipeFamiliarReceptacle;
import ovh.corail.tombstone.recipe.RecipeVoodooPoppetProtection;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;

@Mod.EventBusSubscriber(modid="tombstone")
public class RegistryHandler {
    public static final BlockGrave[] graves = new BlockGrave[]{ModBlocks.grave_simple, ModBlocks.grave_normal, ModBlocks.grave_cross, ModBlocks.tombstone};
    public static final BlockDecorativeGrave[] decorative_graves = new BlockDecorativeGrave[]{ModBlocks.decorative_grave_simple, ModBlocks.decorative_grave_normal, ModBlocks.decorative_grave_cross, ModBlocks.decorative_tombstone};
    public static final Item[] items = new Item[]{ModItems.grave_key, ModItems.scroll_of_knowledge, ModItems.scroll_buff, ModItems.tablet_of_recall, ModItems.tablet_of_home, ModItems.tablet_of_assistance, ModItems.fishing_rod_of_misadventure, ModItems.lost_tablet, ModItems.dust_of_vanishing, ModItems.soul_receptacle, ModItems.familiar_receptacle, ModItems.voodoo_poppet, ModItems.book_of_disenchantment, ModItems.ankh_of_pray, ModItems.lollypop, ModItems.advancement, ModItems.crafting_ingredient};

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry blocksRegistry = event.getRegistry();
        blocksRegistry.registerAll((IForgeRegistryEntry[])graves);
        blocksRegistry.registerAll((IForgeRegistryEntry[])decorative_graves);
        blocksRegistry.register((IForgeRegistryEntry)ModBlocks.dark_marble);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry itemsRegistry = event.getRegistry();
        for (BlockDecorativeGrave decorative_grave : decorative_graves) {
            assert (decorative_grave.getRegistryName() != null);
            itemsRegistry.register(new ItemBlockGrave(decorative_grave).setRegistryName(decorative_grave.getRegistryName()));
        }
        assert (ModBlocks.dark_marble.getRegistryName() != null);
        itemsRegistry.register(new ItemBlock(ModBlocks.dark_marble).setRegistryName(ModBlocks.dark_marble.getRegistryName()));
        itemsRegistry.registerAll((IForgeRegistryEntry[])items);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void renderItems(ModelRegistryEvent event) {
        ModTombstone.PROXY.registerModels();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Potion[]{ModEffects.ghostly_shape, ModEffects.preservation, ModEffects.unstable_intangibleness, ModEffects.diversion, ModEffects.feather_fall, ModEffects.purification, ModEffects.true_sight, ModEffects.exorcism, ModEffects.reach});
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.shadow_step);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.soulbound);
        event.getRegistry().register((IForgeRegistryEntry)ModEnchantments.magic_siphon);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        RecipeEnchantedGraveKey recipeGraveKey = new RecipeEnchantedGraveKey();
        recipeGraveKey.setRegistryName("tombstone", "enchanted_grave_key");
        event.getRegistry().register((IForgeRegistryEntry)recipeGraveKey);
        for (ItemVoodooPoppet.PoppetProtections prot : ItemVoodooPoppet.PoppetProtections.values()) {
            event.getRegistry().register((IForgeRegistryEntry)new RecipeVoodooPoppetProtection(prot));
        }
        RecipeFamiliarReceptacle recipeFamiliarReceptacle = new RecipeFamiliarReceptacle();
        recipeFamiliarReceptacle.setRegistryName("tombstone", "familiar_receptacle");
        event.getRegistry().register((IForgeRegistryEntry)recipeFamiliarReceptacle);
    }
}

