/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import java.util.Random;
import me.ferdz.placeableitems.block.BlockEdible;
import me.ferdz.placeableitems.state.EnumCooked;
import me.ferdz.placeableitems.state.EnumPreciseFacing;
import me.ferdz.placeableitems.tileentity.TEEdible;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlockBiEdible
extends BlockEdible {
    public static final PropertyEnum<EnumCooked> TYPE = PropertyEnum.func_177709_a((String)"type", EnumCooked.class);
    protected int rawFoodLevel;
    protected int cookedFoodLevel;
    protected float rawSaturation;
    protected float cookedSaturation;
    protected Item rawItem;
    protected Item cookedItem;

    public BlockBiEdible(String name, Item rawItem, int rawFoodLevel, float rawSaturation, Item cookedItem, int cookedFoodLevel, float cookedSaturation) {
        super(name);
        this.rawItem = rawItem;
        this.rawFoodLevel = rawFoodLevel;
        this.rawSaturation = rawSaturation;
        this.cookedItem = cookedItem;
        this.cookedFoodLevel = cookedFoodLevel;
        this.cookedSaturation = cookedSaturation;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TEEdible) {
            switch ((EnumCooked)((Object)state.func_177229_b(TYPE))) {
                case RAW: {
                    ((TEEdible)te).bite(this.rawFoodLevel, this.rawSaturation, playerIn, worldIn);
                    return true;
                }
                case COOKED: {
                    ((TEEdible)te).bite(this.cookedFoodLevel, this.cookedSaturation, playerIn, worldIn);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public IBlockState onBlockPlaced(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer.func_184614_ca().func_77973_b().equals(this.rawItem)) {
            return super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(TYPE, (Comparable)((Object)EnumCooked.RAW));
        }
        if (placer.func_184614_ca().func_77973_b().equals(this.cookedItem)) {
            return super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(TYPE, (Comparable)((Object)EnumCooked.COOKED));
        }
        return super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        switch ((EnumCooked)((Object)state.func_177229_b(TYPE))) {
            case RAW: {
                return new ItemStack(this.rawItem);
            }
            case COOKED: {
                return new ItemStack(this.cookedItem);
            }
        }
        return null;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch ((EnumCooked)((Object)state.func_177229_b(TYPE))) {
            case RAW: {
                return this.rawItem;
            }
            case COOKED: {
                return this.cookedItem;
            }
        }
        return null;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState s = super.func_176203_a(meta % 8);
        s = s.func_177226_a(TYPE, (Comparable)((Object)EnumCooked.values()[meta / 8]));
        return s;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int face = ((EnumPreciseFacing)((Object)state.func_177229_b((IProperty)FACING))).ordinal();
        int position = ((EnumCooked)((Object)state.func_177229_b(TYPE))).getID();
        return face + position * 8;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PLATED, TYPE, FACING});
    }
}

