/*
 * Decompiled with CFR 0.152.
 */
package com.laton95.pyramidplunder.world;

import com.laton95.pyramidplunder.block.BlockUrn;
import com.laton95.pyramidplunder.config.ModConfig;
import com.laton95.pyramidplunder.init.ModBlocks;
import com.laton95.pyramidplunder.tileentity.TileEntityUrn;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class UrnGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int zPos;
        Random rand;
        int xPos;
        BlockPos urnPos;
        if (this.isSpawnableDimension(world.field_73011_w.getDimension()) && this.isSpawnableBiome(world, chunkX, chunkZ) && (double)world.field_73012_v.nextFloat() > 1.0 - ModConfig.urnChance && (urnPos = this.findCave(world, chunkX * 16 + (xPos = (rand = new Random(world.func_72905_C() * (long)chunkX * (long)chunkZ)).nextInt(16)) + 8, chunkZ * 16 + (zPos = rand.nextInt(16)) + 8)) != null) {
            world.func_180501_a(urnPos, ModBlocks.URN.func_176223_P().func_177226_a((IProperty)BlockUrn.OPEN, (Comparable)Boolean.valueOf(false)), 2);
            TileEntityUrn urn = (TileEntityUrn)world.func_175625_s(urnPos);
            if (urn != null) {
                urn.setUnopened();
            }
        }
    }

    private boolean isSpawnableBiome(World world, int chunkX, int chunkZ) {
        Biome biome = world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16));
        String biomeName = biome.getRegistryName().toString().substring(biome.getRegistryName().toString().indexOf(58) + 1);
        for (String name : ModConfig.biomeBlackList) {
            if (!biomeName.equals(name)) continue;
            return false;
        }
        return true;
    }

    private boolean isSpawnableDimension(int dimId) {
        for (int id : ModConfig.dimensionBlacklist) {
            if (id != dimId) continue;
            return false;
        }
        return true;
    }

    private BlockPos findCave(World world, int x, int z) {
        int y = ModConfig.minHeight;
        while ((double)y < Math.min((double)ModConfig.maxHeight, world.field_73011_w.getHorizon())) {
            BlockPos pos = new BlockPos(x, y, z);
            if ((world.func_180495_p(pos).func_185904_a() == Material.field_151579_a || world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) && world.func_180495_p(pos.func_177977_b()).func_185898_k()) {
                return pos;
            }
            ++y;
        }
        return null;
    }
}

