/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.rwtema.monkmod.MonkMod;
import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.advancements.JSonObjBuilder;
import com.rwtema.monkmod.advancements.MonkRequirement;
import com.rwtema.monkmod.config.MonkConfiguration;
import com.rwtema.monkmod.helper.TranslateHelper;
import com.rwtema.monkmod.levels.MonkLevelManager;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.storage.SaveFormatOld;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;

public class MonkAdvancements {
    private static final HashSet<String> keys = new HashSet();

    public static void registerAdvancements(@Nonnull MinecraftServer server) {
        if (MonkMod.debug) {
            keys.clear();
        }
        try {
            MonkAdvancements.loadData(server);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (MonkMod.debug) {
            MonkMod.logger.info(keys.stream().sorted().map(s -> s + "=" + (TranslateHelper.canTranslate(s) ? TranslateHelper.translateKey(s) : "")).collect(Collectors.joining("\n", "Keys::\n", "\n")));
        }
    }

    private static void loadData(MinecraftServer server) throws IOException {
        SaveFormatOld activeAnvilConverter = (SaveFormatOld)server.func_71254_M();
        File savesDirectory = activeAnvilConverter.field_75808_a;
        File worldFile = new File(savesDirectory, server.func_71270_I());
        File directory = new File(new File(new File(worldFile, "data"), "advancements"), "monk");
        if (directory.exists()) {
            FileUtils.cleanDirectory((File)directory);
        } else if (!directory.mkdirs()) {
            throw new IOException("Unable to generate advancements");
        }
        JSonObjBuilder.writeJSon(new File(directory, "root.json"), JSonObjBuilder.json().add("display", JSonObjBuilder.json().add("icon", JSonObjBuilder.json().add("item", ((ResourceLocation)Validate.notNull((Object)MonkMod.ITEM_MONK_BASE.getRegistryName())).toString()).add("nbt", MonkAdvancements.getAdd(MonkConfiguration.data[0].texture))).add("title", MonkAdvancements.serializeTextComponent((ITextComponent)new TextComponentTranslation("monk.advancements.level.start", new Object[0]))).add("description", MonkAdvancements.serializeTextComponent((ITextComponent)new TextComponentTranslation("monk.advancements.level.start.desc", new Object[0]))).add("background", "monk:textures/advancements/advancement_background.png").add("show_toast", true).add("announce_to_chat", false).add("hidden", false)).add("criteria", JSonObjBuilder.json().add("level", JSonObjBuilder.json().add("trigger", "monk:levelup").add("conditions", JSonObjBuilder.json().add("level", 0)))).build());
        for (int level = 1; level <= MonkMod.MAX_LEVEL; ++level) {
            JSonObjBuilder.writeJSon(new File(directory, "level_" + level + ".json"), JSonObjBuilder.json().add("display", JSonObjBuilder.json().add("icon", JSonObjBuilder.json().add("item", ((ResourceLocation)Validate.notNull((Object)MonkMod.ITEM_MONK_BASE.getRegistryName())).toString()).add("nbt", MonkAdvancements.getAdd(MonkConfiguration.data[level].texture))).add("title", MonkAdvancements.serializeTextComponent((ITextComponent)new TextComponentTranslation("monk.advancements.level", new Object[]{level}))).add("description", MonkAdvancements.serializeTextComponent(((MonkRequirement)MonkLevelManager.requirements.get(level)).getDescriptionComponent())).add("show_toast", true).add("announce_to_chat", true).add("hidden", false)).add("parent", level == 1 ? "monk:root" : "monk:level_" + (level - 1)).add("criteria", JSonObjBuilder.json().add("level", JSonObjBuilder.json().add("trigger", "monk:levelup").add("conditions", JSonObjBuilder.json().add("level", level)))).build());
            MonkConfiguration.LevelData datum = MonkConfiguration.data[level];
            ITextComponent textComponent = null;
            for (MonkAbility ability : datum.toAdd) {
                if (textComponent == null) {
                    textComponent = ability.getTextComponent();
                    continue;
                }
                textComponent.func_150258_a("\n").func_150257_a(ability.getTextComponent());
            }
            if (textComponent == null) continue;
            JSonObjBuilder.writeJSon(new File(directory, "level_reward_" + level + ".json"), JSonObjBuilder.json().add("display", JSonObjBuilder.json().add("icon", JSonObjBuilder.json().add("item", ((ResourceLocation)Validate.notNull((Object)MonkMod.ITEM_MONK_BASE.getRegistryName())).toString()).add("nbt", MonkAdvancements.getAdd("monk:icon/rewards"))).add("title", MonkAdvancements.serializeTextComponent((ITextComponent)new TextComponentTranslation("monk.advancements.reward", new Object[]{level}))).add("description", MonkAdvancements.serializeTextComponent(textComponent)).add("show_toast", false).add("announce_to_chat", false).add("hidden", true)).add("parent", level == 1 ? "monk:root" : "monk:level_" + (level - 1)).add("criteria", JSonObjBuilder.json().add("level", JSonObjBuilder.json().add("trigger", "monk:levelup").add("conditions", JSonObjBuilder.json().add("level", level)))).build());
        }
    }

    private static String getAdd(String textureName) {
        return "{\"icon\":\"" + textureName + "\"}";
    }

    @Nonnull
    private static JsonElement serializeTextComponent(ITextComponent component) {
        if (MonkMod.debug) {
            ITextComponent textComponent;
            LinkedList<ITextComponent> textComponents = new LinkedList<ITextComponent>();
            textComponents.add(component);
            while ((textComponent = (ITextComponent)textComponents.pollFirst()) != null) {
                if (textComponent instanceof TextComponentTranslation) {
                    String key = ((TextComponentTranslation)textComponent).func_150268_i();
                    keys.add(key);
                }
                textComponents.addAll(textComponent.func_150253_a());
            }
        }
        return new JsonParser().parse(ITextComponent.Serializer.func_150696_a((ITextComponent)component));
    }
}

