/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.config;

import com.rwtema.monkmod.MonkMod;
import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.advancements.MonkRequirement;
import com.rwtema.monkmod.factory.Factory;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Property;

public class FactoryEntry<T> {
    final Factory<T> factory;
    final HashMap<Factory.Parameter, String> values = new HashMap();

    public FactoryEntry(Factory<T> factory) {
        this.factory = factory;
    }

    public static FactoryEntry<MonkAbility> ability(String name) {
        return new FactoryEntry<MonkAbility>(Factory.abilityFactories.get(name));
    }

    public static FactoryEntry<MonkRequirement> requirement(String name) {
        return new FactoryEntry<MonkRequirement>(Factory.requirementFactories.get(name));
    }

    public void writeToConfig(String category) {
        String categoryName = category + "." + this.factory.name;
        MonkMod.config.getCategory(categoryName);
        for (Factory.Parameter parameter : this.factory.parameterList) {
            String s = this.values.getOrDefault(parameter, parameter._default);
            if (s == null) {
                throw new IllegalArgumentException("Missing parameter: " + parameter.name);
            }
            switch (parameter.type) {
                case INTEGER: {
                    MonkMod.config.get(categoryName, parameter.name, s, null, Property.Type.INTEGER).getInt();
                    break;
                }
                case FLOAT: {
                    MonkMod.config.get(categoryName, parameter.name, s, null, Property.Type.DOUBLE).getDouble();
                    break;
                }
                case STRING: {
                    MonkMod.config.get(categoryName, parameter.name, s, null, Property.Type.STRING).getString();
                    break;
                }
                case STRINGLIST: {
                    MonkMod.config.getStringList(parameter.name, categoryName, s.split(","), null);
                    break;
                }
                case TEXT_COMPONENT: {
                    MonkMod.config.get(categoryName, parameter.name, s, null, Property.Type.STRING).getString();
                }
            }
        }
    }

    @Nonnull
    public FactoryEntry<T> setString(String key, String value) {
        this.values.put(this.getParam(key, Factory.Type.STRING), value);
        return this;
    }

    @Nonnull
    public FactoryEntry<T> setInt(String key, @Nonnull Integer value) {
        this.values.put(this.getParam(key, Factory.Type.INTEGER), value.toString());
        return this;
    }

    @Nonnull
    public FactoryEntry<T> setFloat(String key, @Nonnull Float value) {
        this.values.put(this.getParam(key, Factory.Type.FLOAT), value.toString());
        return this;
    }

    @Nonnull
    public FactoryEntry<T> setStringList(String key, String ... value) {
        this.values.put(this.getParam(key, Factory.Type.STRINGLIST), Stream.of(value).collect(Collectors.joining(",")));
        return this;
    }

    @Nonnull
    public FactoryEntry<T> setTextComponent(String key, String value) {
        this.values.put(this.getParam(key, Factory.Type.TEXT_COMPONENT), value);
        return this;
    }

    @Nonnull
    public Factory.Parameter getParam(String key, Factory.Type expectedType) {
        for (Factory.Parameter parameter : this.factory.parameterList) {
            if (!parameter.name.equals(key)) continue;
            if (parameter.type != expectedType && (parameter.type != Factory.Type.FLOAT || expectedType != Factory.Type.INTEGER)) {
                throw new IllegalArgumentException(key + " does not match expected type " + (Object)((Object)expectedType));
            }
            return parameter;
        }
        throw new IllegalArgumentException("Illegal key: " + key);
    }
}

