/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.factory;

import com.google.common.collect.Sets;
import com.rwtema.monkmod.abilities.MonkAbilitiyProtectionLava;
import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.abilities.MonkAbilityArmor;
import com.rwtema.monkmod.abilities.MonkAbilityArmorToughness;
import com.rwtema.monkmod.abilities.MonkAbilityBlindness;
import com.rwtema.monkmod.abilities.MonkAbilityBlink;
import com.rwtema.monkmod.abilities.MonkAbilityCatchArrows;
import com.rwtema.monkmod.abilities.MonkAbilityCreeperKiss;
import com.rwtema.monkmod.abilities.MonkAbilityExplosionProof;
import com.rwtema.monkmod.abilities.MonkAbilityFeatherFalling;
import com.rwtema.monkmod.abilities.MonkAbilityFly;
import com.rwtema.monkmod.abilities.MonkAbilityFullWaterBreathing;
import com.rwtema.monkmod.abilities.MonkAbilityGlassTouch;
import com.rwtema.monkmod.abilities.MonkAbilityHealPotionEffects;
import com.rwtema.monkmod.abilities.MonkAbilityHealth;
import com.rwtema.monkmod.abilities.MonkAbilityHunger;
import com.rwtema.monkmod.abilities.MonkAbilityJump;
import com.rwtema.monkmod.abilities.MonkAbilityMining;
import com.rwtema.monkmod.abilities.MonkAbilityProtectionFire;
import com.rwtema.monkmod.abilities.MonkAbilitySpeed;
import com.rwtema.monkmod.abilities.MonkAbilityStepUp;
import com.rwtema.monkmod.abilities.MonkAbilityStrength;
import com.rwtema.monkmod.abilities.MonkAbilityTameAnimals;
import com.rwtema.monkmod.abilities.MonkAbilityWalkOnWater;
import com.rwtema.monkmod.abilities.MonkAbilityWater;
import com.rwtema.monkmod.abilities.MonkAbilityWitheringStare;
import com.rwtema.monkmod.advancements.MonkRequirement;
import com.rwtema.monkmod.advancements.MonkRequirementAdvancement;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementArrow;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementBedrockSleep;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementBreakBlockBareHanded;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementDescentAscent;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementEnemyDefeat;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementFall;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementKill;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementKissCreeper;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementMeditateEndermen;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementOcean;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementPet;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementSleepCactus;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementStare;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementSunriseSunset;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementWalk;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementWaterMeditation;
import com.rwtema.monkmod.factory.IFactoryMade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class Factory<T> {
    @Nonnull
    public static final Map<String, Factory<MonkAbility>> abilityFactories = new HashMap<String, Factory<MonkAbility>>();
    @Nonnull
    public static final Map<String, Factory<MonkRequirement>> requirementFactories = new HashMap<String, Factory<MonkRequirement>>();
    public static boolean shouldRegister = true;
    public final String name;
    public final Function<Parameters, ? extends T> function;
    public final List<Parameter> parameterList;

    public Factory(String name, Function<Parameters, ? extends T> function, List<Parameter> parameterList) {
        this.name = name;
        this.function = function;
        this.parameterList = parameterList;
    }

    public static void init() {
        Factory.registerAbility(parameters -> new MonkAbilityArmor(parameters.getFloat("armor")));
        Factory.registerAbility(parameters -> new MonkAbilityArmorToughness(parameters.getFloat("armor_toughness")));
        Factory.registerAbility(parameters -> new MonkAbilityBlindness());
        Factory.registerAbility(parameters -> new MonkAbilityBlink());
        Factory.registerAbility(parameters -> new MonkAbilityCatchArrows());
        Factory.registerAbility(parameters -> new MonkAbilityCreeperKiss());
        Factory.registerAbility(parameters -> new MonkAbilityExplosionProof(parameters.getFloat("multiplier")));
        Factory.registerAbility(parameters -> new MonkAbilityFeatherFalling(parameters.getFloat("multiplier")));
        Factory.registerAbility(parameters -> new MonkAbilityFly());
        Factory.registerAbility(parameters -> new MonkAbilityGlassTouch());
        Factory.registerAbility(parameters -> new MonkAbilityHealPotionEffects());
        Factory.registerAbility(parameters -> new MonkAbilityHealth(parameters.getFloat("health_increase")));
        Factory.registerAbility(parameters -> new MonkAbilityHunger(parameters.getFloat("hunger_chance")));
        Factory.registerAbility(parameters -> new MonkAbilityJump(parameters.getFloat("jump")));
        Factory.registerAbility(parameters -> new MonkAbilityMining(parameters.getInt("harvest_level"), parameters.getFloat("speed_increase"), Sets.newHashSet((Object[])parameters.getStringList("harvest_tools", new String[]{"", "pickaxe", "shovel", "axe"}))));
        Factory.registerAbility(parameters -> new MonkAbilityProtectionFire(parameters.getFloat("multiplier")));
        Factory.registerAbility(parameters -> new MonkAbilitiyProtectionLava());
        Factory.registerAbility(parameters -> new MonkAbilitySpeed(parameters.getFloat("increase")));
        Factory.registerAbility(parameters -> new MonkAbilityStepUp());
        Factory.registerAbility(parameters -> new MonkAbilityStrength(parameters.getFloat("damage")));
        Factory.registerAbility(parameters -> new MonkAbilityTameAnimals());
        Factory.registerAbility(parameters -> new MonkAbilityWalkOnWater());
        Factory.registerAbility(parameters -> new MonkAbilityWater());
        Factory.registerAbility(parameters -> new MonkAbilityFullWaterBreathing());
        Factory.registerAbility(parameters -> new MonkAbilityWitheringStare());
        Factory.registerRequirement(parameters -> {
            final ResourceLocation resourceLocation = new ResourceLocation(parameters.getString("block"));
            return new MonkRequirementBreakBlockBareHanded("break_block", (world, pos, state) -> resourceLocation.equals((Object)state.func_177230_c().getRegistryName()), parameters.getInt("number")){

                @Override
                @Nonnull
                protected Object[] args() {
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
                    return new Object[]{this.requirementLimit, new ItemStack(block).func_151000_E()};
                }
            };
        });
        Factory.registerRequirement(parameters -> new MonkRequirementBreakBlockBareHanded("break_wood", (world, pos, state) -> state.func_177230_c().isWood((IBlockAccess)world, pos), parameters.getInt("number")));
        Factory.registerRequirement(parameters -> new MonkRequirementOcean(parameters.getInt("swim_time", 280)));
        Factory.registerRequirement(parameters -> new MonkRequirementSunriseSunset(200));
        Factory.registerRequirement(parameters -> new MonkRequirementPet(parameters.getInt("number")));
        Factory.registerRequirement(parameters -> new MonkRequirementWalk(parameters.getInt("distance"), "sprint"){

            @Override
            public boolean satisfiesRequirements(@Nonnull EntityPlayerMP player) {
                return player.func_70051_ag() && super.satisfiesRequirements(player);
            }
        });
        Factory.registerRequirement(parameters -> new MonkRequirementKill("kill_undead", parameters.getInt("kills")){

            @Override
            protected boolean isValidEntity(@Nonnull LivingDeathEvent event) {
                return event.getEntityLiving().func_70662_br();
            }
        });
        Factory.registerRequirement(parameters -> new MonkRequirementWalk(parameters.getInt("distance"), "walk_fire"){

            @Override
            protected void onGrant(@Nonnull EntityPlayerMP player) {
                player.func_70066_B();
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 200, 2));
            }

            @Override
            public boolean satisfiesRequirements(@Nonnull EntityPlayerMP player) {
                return (player.func_70045_F() || player.func_70027_ad()) && player.field_70170_p.func_147470_e(player.func_174813_aQ()) && super.satisfiesRequirements(player);
            }
        });
        Factory.registerRequirement(parameters -> new MonkRequirementFall(parameters.getInt("distance")));
        Factory.registerRequirement(parameters -> new MonkRequirementKissCreeper());
        Factory.registerRequirement(parameters -> new MonkRequirementArrow(parameters.getInt("dodges")));
        Factory.registerRequirement(parameters -> new MonkRequirementWaterMeditation(parameters.getInt("stare_time")));
        Factory.registerRequirement(parameters -> new MonkRequirementStare(parameters.getInt("stare_time")));
        Factory.registerRequirement(parameters -> new MonkRequirementMeditateEndermen(parameters.getInt("time", 600)));
        Factory.registerRequirement(parameters -> new MonkRequirementBedrockSleep());
        Factory.registerRequirement(parameters -> new MonkRequirementSleepCactus());
        Factory.registerRequirement(parameters -> new MonkRequirementAdvancement(new ResourceLocation(parameters.getString("advancement_resource_location")), parameters.getTextComponent("achievement_name", (ITextComponent)new TextComponentString("Achievement Name"))));
        Factory.registerRequirement(parameters -> new MonkRequirementKill("kill_hostile", parameters.getInt("kills")){

            @Override
            protected boolean isValidEntity(@Nonnull LivingDeathEvent event) {
                return event.getEntity() instanceof IMob;
            }
        });
        Factory.registerRequirement(parameters -> new MonkRequirementKill("kill_blind", parameters.getInt("kills")){

            @Override
            protected boolean isValidEntity(@Nonnull LivingDeathEvent event) {
                return event.getEntity() instanceof IMob;
            }

            @Override
            protected void onGrant(@Nonnull EntityPlayerMP player) {
                super.onGrant(player);
                player.func_184589_d(MobEffects.field_76440_q);
            }
        });
        Factory.registerRequirement(parameters -> new MonkRequirementEnemyDefeat("kill_entity_type", parameters.getInt("kills"), new ResourceLocation(parameters.getString("entity_type"))));
        Factory.registerRequirement(parameters -> new MonkRequirementDescentAscent());
    }

    public static void registerAbility(@Nonnull Function<Parameters, MonkAbility> function) {
        Factory.register(abilityFactories, function);
    }

    public static void registerRequirement(@Nonnull Function<Parameters, MonkRequirement> function) {
        Factory.register(requirementFactories, function);
    }

    public static <T extends IFactoryMade> void register(Map<String, Factory<T>> factoryMap, Function<Parameters, T> function) {
        ParameterLoader parameterLoader = new ParameterLoader();
        shouldRegister = false;
        IFactoryMade apply = (IFactoryMade)function.apply(parameterLoader);
        shouldRegister = true;
        MinecraftForge.EVENT_BUS.unregister((Object)apply);
        String key = apply.getKey();
        factoryMap.put(key, new Factory<T>(key, function, parameterLoader.parameterList));
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        if (!this.parameterList.isEmpty()) {
            builder.append(" <");
            builder.append(this.parameterList.stream().map(parameter -> {
                StringBuilder b = new StringBuilder();
                switch (parameter.type) {
                    case INTEGER: {
                        b.append("I:");
                        break;
                    }
                    case FLOAT: {
                        b.append("D:");
                        break;
                    }
                    case STRING: {
                        b.append("S:");
                        break;
                    }
                    case STRINGLIST: {
                        b.append("S[]:");
                    }
                }
                b.append(parameter.name);
                if (parameter._default != null) {
                    b.append("=\"");
                    b.append(parameter._default);
                    b.append("\"");
                }
                return b;
            }).collect(Collectors.joining(" ")));
            builder.append(">");
        }
        return builder.toString();
    }

    public static class Parameter {
        public final String name;
        public final Type type;
        @Nullable
        public final String _default;

        public Parameter(String name, Type type, @Nullable String aDefault) {
            this.name = name;
            this.type = type;
            this._default = aDefault;
        }
    }

    private static class ParameterLoader
    extends Parameters {
        @Nonnull
        final List<Parameter> parameterList = new ArrayList<Parameter>();

        private ParameterLoader() {
        }

        @Override
        public float getFloat(String key) {
            this.parameterList.add(new Parameter(key, Type.FLOAT, null));
            return 0.0f;
        }

        @Override
        public float getFloat(String key, float _default) {
            this.parameterList.add(new Parameter(key, Type.FLOAT, Float.toString(_default)));
            return 0.0f;
        }

        @Override
        public int getInt(String key) {
            this.parameterList.add(new Parameter(key, Type.INTEGER, null));
            return 0;
        }

        @Override
        public int getInt(String key, int _default) {
            this.parameterList.add(new Parameter(key, Type.INTEGER, Integer.toString(_default)));
            return 0;
        }

        @Override
        @Nonnull
        public String getString(String key) {
            this.parameterList.add(new Parameter(key, Type.STRING, null));
            return "";
        }

        @Override
        @Nonnull
        public String getString(String key, String _default) {
            this.parameterList.add(new Parameter(key, Type.STRING, _default));
            return "";
        }

        @Override
        @Nonnull
        public String[] getStringList(String key) {
            this.parameterList.add(new Parameter(key, Type.STRINGLIST, null));
            return new String[0];
        }

        @Override
        public ITextComponent getTextComponent(String key) {
            this.parameterList.add(new Parameter(key, Type.TEXT_COMPONENT, ITextComponent.Serializer.func_150696_a((ITextComponent)new TextComponentString("Example"))));
            return new TextComponentString("");
        }

        @Override
        public ITextComponent getTextComponent(String key, ITextComponent _default) {
            this.parameterList.add(new Parameter(key, Type.TEXT_COMPONENT, ITextComponent.Serializer.func_150696_a((ITextComponent)_default)));
            return new TextComponentString("");
        }

        @Override
        @Nonnull
        public String[] getStringList(String key, String[] _defaults) {
            this.parameterList.add(new Parameter(key, Type.STRINGLIST, Stream.of(_defaults).collect(Collectors.joining(","))));
            return new String[0];
        }
    }

    public static abstract class Parameters {
        public abstract float getFloat(String var1);

        public abstract float getFloat(String var1, float var2);

        public abstract int getInt(String var1);

        public abstract int getInt(String var1, int var2);

        public abstract String getString(String var1);

        public abstract String getString(String var1, String var2);

        public String[] getStringList(String key) {
            String string = this.getString(key);
            return string.split(",");
        }

        public abstract ITextComponent getTextComponent(String var1);

        public abstract ITextComponent getTextComponent(String var1, ITextComponent var2);

        public String[] getStringList(String key, String[] _defaults) {
            return this.getString(key, Stream.of(_defaults).collect(Collectors.joining(","))).split(",");
        }
    }

    public static enum Type {
        INTEGER,
        FLOAT,
        STRING,
        STRINGLIST,
        TEXT_COMPONENT;

    }
}

