/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.addon.toughasnails;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.segments.FloatSegment;
import com.creativemd.igcm.api.segments.IntegerSegment;
import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.addon.toughasnails.ToughAsNailsAddon;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.VisualPersistent;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;
import toughasnails.api.TANCapabilities;
import toughasnails.api.stat.capability.IThirst;

public class ThirstHandler
extends VisualHandler {
    public float defaultIntensity = 0.0f;
    public float maxIntensity = 5.0f;
    public float fadeFactor = 0.05f;
    public int minThirstLevelEffected = 2;
    public int maxThirstLevelEffected = 8;

    public ThirstHandler() {
        super("thirst", "addon for ToughAsNailsAddon");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.defaultIntensity = config.getFloat("defaultIntensity", this.name, this.defaultIntensity, 0.0f, 10000.0f, "the default/max thirst");
        this.maxIntensity = config.getFloat("maxIntensity", this.name, this.maxIntensity, 0.0f, 10000.0f, "lowest thirst");
        this.fadeFactor = config.getFloat("fadeFactor", this.name, this.fadeFactor, 0.0f, 10000.0f, "thirst += fadeFactor per Tick");
        this.minThirstLevelEffected = config.getInt("minThirstLevelEffected", this.name, this.minThirstLevelEffected, 0, 20, "the minimum point thirst is effected");
        this.maxThirstLevelEffected = config.getInt("maxThirstLevelEffected", this.name, this.maxThirstLevelEffected, 0, 20, "the maximum point thirst is effected");
    }

    @Override
    @Optional.Method(modid="igcm")
    public void registerConfigElements(ConfigBranch branch) {
        branch.registerElement("defaultIntensity", (ConfigElement)new FloatSegment("defaultIntensity", Float.valueOf(0.0f), 0.0f, 10000.0f).setToolTip(new String[]{"the default/max thirst"}));
        branch.registerElement("maxIntensity", (ConfigElement)new FloatSegment("maxIntensity", Float.valueOf(5.0f), 0.0f, 10000.0f).setToolTip(new String[]{"lowest thirst"}));
        branch.registerElement("fadeFactor", (ConfigElement)new FloatSegment("fadeFactor", Float.valueOf(0.05f), 0.0f, 10000.0f).setToolTip(new String[]{"thirst += fadeFactor per Tick"}));
        branch.registerElement("minThirstLevelEffected", (ConfigElement)new IntegerSegment("minThirstLevelEffected", Integer.valueOf(2), 0, 20).setToolTip(new String[]{"the minimum point thirst is effected"}));
        branch.registerElement("maxThirstLevelEffected", (ConfigElement)new IntegerSegment("maxThirstLevelEffected", Integer.valueOf(8), 0, 20).setToolTip(new String[]{"the maximum point thirst is effected"}));
    }

    @Override
    @Optional.Method(modid="igcm")
    public void receiveConfigElements(ConfigBranch branch) {
        this.defaultIntensity = ((Float)branch.getValue("defaultIntensity")).floatValue();
        this.maxIntensity = ((Float)branch.getValue("maxIntensity")).floatValue();
        this.fadeFactor = ((Float)branch.getValue("fadeFactor")).floatValue();
        this.minThirstLevelEffected = (Integer)branch.getValue("minThirstLevelEffected");
        this.maxThirstLevelEffected = (Integer)branch.getValue("maxThirstLevelEffected");
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        VisualPersistent visual = VisualManager.getPersitentVisual(ToughAsNailsAddon.focus);
        if (visual != null) {
            float aimedSaturation = this.defaultIntensity;
            if (player != null && ((IThirst)player.getCapability(TANCapabilities.THIRST, null)).getThirst() <= this.maxThirstLevelEffected) {
                float leftFoodInSpan = ((IThirst)player.getCapability(TANCapabilities.THIRST, null)).getThirst() - this.minThirstLevelEffected;
                float spanLength = this.maxThirstLevelEffected - this.minThirstLevelEffected;
                aimedSaturation = (1.0f - leftFoodInSpan / spanLength) * this.maxIntensity;
            }
            if (visual.getIntensity(1.0f) < aimedSaturation) {
                visual.setIntensity(Math.min(visual.getIntensity(1.0f) + this.fadeFactor, aimedSaturation));
            } else if (visual.getIntensity(1.0f) > aimedSaturation) {
                visual.setIntensity(Math.max(visual.getIntensity(1.0f) - this.fadeFactor, aimedSaturation));
            }
        }
    }
}

