/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.Source;

public class SoundMuteHandler {
    public static boolean isMuting = false;
    public static HashMap<Source, Float> sources = null;
    public static Library soundLibrary;
    public static SoundSystem sndSystem;
    public static ArrayList<String> ignoredSounds;
    public static int mutingTime;
    public static int timer;
    public static float mutingFactor;

    public static void tick() {
        if (isMuting) {
            int remaining = mutingTime - timer;
            if (remaining <= 0) {
                SoundMuteHandler.endMuting();
            } else {
                SoundMuteHandler.updateSounds();
                SoundMuteHandler.setMuteFactor(SoundMuteHandler.getMutingFactorPerTick());
                ++timer;
            }
        }
    }

    public static float getMutingFactorPerTick() {
        int remaining = mutingTime - timer;
        float percentage = (float)remaining / (float)mutingTime;
        float volumeSpan = 1.0f - mutingFactor;
        return (float)((double)volumeSpan * Math.pow(1.0f - percentage, 2.0) + (double)mutingFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSounds() {
        try {
            HashMap sourcesAndIDs = null;
            Iterator iterator = SoundSystemConfig.THREAD_SYNC;
            synchronized (iterator) {
                sourcesAndIDs = new HashMap(soundLibrary.getSources());
            }
            for (Source source : sourcesAndIDs.values()) {
                if (sources.containsKey(source) || ignoredSounds.contains(source.sourcename)) continue;
                sources.put(source, Float.valueOf(source.sourceVolume));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startMuting(int mutingTime, float mutingFactor) {
        if (soundLibrary == null) {
            SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
            SoundManager sndManager = (SoundManager)ReflectionHelper.getPrivateValue(SoundHandler.class, (Object)handler, (String[])new String[]{"sndManager", "field_147694_f"});
            sndSystem = (SoundSystem)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)sndManager, (String[])new String[]{"sndSystem", "field_148620_e"});
            soundLibrary = (Library)ReflectionHelper.getPrivateValue(SoundSystem.class, (Object)sndSystem, (String[])new String[]{"soundLibrary"});
        }
        if (isMuting && SoundMuteHandler.getMutingFactorPerTick() > mutingFactor) {
            SoundMuteHandler.mutingFactor = mutingFactor;
            SoundMuteHandler.mutingTime = mutingTime;
            timer = 0;
        }
        if (!isMuting) {
            SoundMuteHandler.mutingFactor = mutingFactor;
            SoundMuteHandler.mutingTime = mutingTime;
            timer = 0;
            sources = new HashMap();
            ignoredSounds = new ArrayList();
            SoundMuteHandler.updateSounds();
            isMuting = true;
        }
    }

    public static void endMuting() {
        SoundMuteHandler.setMuteFactor(1.0f);
        sources = null;
        isMuting = false;
        ignoredSounds = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setMuteFactor(float muteVolume) {
        if (isMuting && sources != null) {
            Object object = SoundSystemConfig.THREAD_SYNC;
            synchronized (object) {
                for (Source source : sources.keySet()) {
                    sndSystem.setVolume(source.sourcename, sources.get(source).floatValue() * muteVolume);
                }
            }
        }
    }

    static {
        timer = 0;
    }
}

