/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.segments.BooleanSegment;
import com.creativemd.igcm.api.segments.FloatSegment;
import com.creativemd.igcm.api.segments.IntegerSegment;
import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.events.SoundMuteHandler;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;

public class ExplosionHandler
extends VisualHandler {
    public int maxExplosionTime = 1000;
    public float explosionTimeModifier = 20.0f;
    public float minExplosionVolume = 0.0f;
    public float explosionVolumeModifier = 10.0f;
    public float maxBeepVolume = 0.5f;
    public float maxBlur = 100.0f;
    public float blurTimeFactor = 2.5f;
    public boolean useShortRinging = false;
    public float dustSplatsMultiplier = 10.0f;
    public int dustMinDuration = 500;
    public int dustMaxDuration = 1000;

    public ExplosionHandler() {
        super("explosion", "");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.maxExplosionTime = config.getInt("maxExplosionTime", this.name, this.maxExplosionTime, 0, 100000, "maximum explosion duration");
        this.explosionTimeModifier = config.getFloat("explosionTimeModifier", this.name, this.explosionTimeModifier, 0.0f, 100000.0f, "time = Math.max(maxExplosionTime, damage*explosionTimeModifier)");
        this.minExplosionVolume = config.getFloat("minExplosionVolume", this.name, this.minExplosionVolume, 0.0f, 100000.0f, "factor of all other sounds (muting effect)");
        this.explosionVolumeModifier = config.getFloat("explosionVolumeModifier", this.name, this.explosionVolumeModifier, 0.0f, 100000.0f, "volume of beep = damage/ConfigCore.explosionVolumeModifier");
        this.maxBeepVolume = config.getFloat("maxBeepVolume", this.name, this.maxBeepVolume, 0.0f, 100000.0f, "max volume of a beep");
        this.maxBlur = config.getFloat("maxBlur", this.name, this.maxBlur, 0.0f, 100000.0f, "max blur effect");
        this.blurTimeFactor = config.getFloat("blurTimeFactor", this.name, this.blurTimeFactor, 0.0f, 100000.0f, "time of blur = time of muted sounds / blurTimeFactor");
        this.useShortRinging = config.getBoolean("useShortRinging", this.name, false, "If true plays short ringing sound");
        this.dustSplatsMultiplier = config.getFloat("dustSplatsMultiplier", this.name, this.dustSplatsMultiplier, 0.0f, 10000.0f, "damage * multiplier = number of splats");
        this.dustMinDuration = config.getInt("dustMinDuration", this.name, this.dustMinDuration, 1, 100000, "min duration of one particle");
        this.dustMaxDuration = config.getInt("dustMaxDuration", this.name, this.dustMaxDuration, 1, 100000, "max duration of one particle");
    }

    @Override
    @Optional.Method(modid="igcm")
    public void registerConfigElements(ConfigBranch branch) {
        branch.registerElement("maxExplosionTime", (ConfigElement)new IntegerSegment("maxExplosionTime", Integer.valueOf(1000), 0, 100000).setToolTip(new String[]{"maximum explosion duration"}));
        branch.registerElement("explosionTimeModifier", (ConfigElement)new FloatSegment("explosionTimeModifier", Float.valueOf(20.0f), 0.0f, 100000.0f).setToolTip(new String[]{"time = Math.max(maxExplosionTime, damage*explosionTimeModifier)"}));
        branch.registerElement("minExplosionVolume", (ConfigElement)new FloatSegment("minExplosionVolume", Float.valueOf(0.0f), 0.0f, 10000.0f).setToolTip(new String[]{"factor of all other sounds (muting effect)"}));
        branch.registerElement("explosionVolumeModifier", (ConfigElement)new FloatSegment("explosionVolumeModifier", Float.valueOf(10.0f), 0.0f, 10000.0f).setToolTip(new String[]{"volume of beep = damage/ConfigCore.explosionVolumeModifier"}));
        branch.registerElement("maxBeepVolume", (ConfigElement)new FloatSegment("maxBeepVolume", Float.valueOf(0.5f), 0.0f, 10000.0f).setToolTip(new String[]{"max volume of a beep"}));
        branch.registerElement("maxBlur", (ConfigElement)new FloatSegment("maxBlur", Float.valueOf(100.0f), 0.0f, 10000.0f).setToolTip(new String[]{"max blur effect"}));
        branch.registerElement("blurTimeFactor", (ConfigElement)new FloatSegment("blurTimeFactor", Float.valueOf(2.5f), 0.0f, 10000.0f).setToolTip(new String[]{"time of blur = time of muted sounds / blurTimeFactor"}));
        branch.registerElement("useShortRinging", (ConfigElement)new BooleanSegment("useShortRinging", Boolean.valueOf(false)).setToolTip(new String[]{"If true plays short ringing sound"}));
        branch.registerElement("dustSplatsMultiplier", (ConfigElement)new FloatSegment("dustSplatsMultiplier", Float.valueOf(10.0f), 0.0f, 10000.0f).setToolTip(new String[]{"damage * multiplier = number of splats"}));
        branch.registerElement("dustMinDuration", (ConfigElement)new IntegerSegment("dustMinDuration", Integer.valueOf(500), 0, 10000).setToolTip(new String[]{"min duration of one particle"}));
        branch.registerElement("dustMaxDuration", (ConfigElement)new IntegerSegment("dustMaxDuration", Integer.valueOf(1000), 0, 10000).setToolTip(new String[]{"max duration of one particle"}));
    }

    @Override
    @Optional.Method(modid="igcm")
    public void receiveConfigElements(ConfigBranch branch) {
        this.maxExplosionTime = (Integer)branch.getValue("maxExplosionTime");
        this.explosionTimeModifier = ((Float)branch.getValue("explosionTimeModifier")).floatValue();
        this.minExplosionVolume = ((Float)branch.getValue("minExplosionVolume")).floatValue();
        this.explosionVolumeModifier = ((Float)branch.getValue("explosionVolumeModifier")).floatValue();
        this.maxBeepVolume = ((Float)branch.getValue("maxBeepVolume")).floatValue();
        this.maxBlur = ((Float)branch.getValue("maxBlur")).floatValue();
        this.blurTimeFactor = ((Float)branch.getValue("blurTimeFactor")).floatValue();
        this.useShortRinging = (Boolean)branch.getValue("useShortRinging");
        this.dustSplatsMultiplier = ((Float)branch.getValue("dustSplatsMultiplier")).floatValue();
        this.dustMinDuration = (Integer)branch.getValue("dustMinDuration");
        this.dustMaxDuration = (Integer)branch.getValue("dustMaxDuration");
    }

    @Override
    public void onExplosion(EntityPlayer player, double x, double y, double z, double distance) {
        if (distance < 5.0) {
            float damage = (float)(1.0 - distance / 5.0) * 5.0f;
            System.out.println(damage);
            VisualManager.addVisualsWithShading(VisualType.dust, (int)Math.min(40.0f, damage * this.dustSplatsMultiplier), this.dustMinDuration, this.dustMaxDuration);
            float volume = Math.max(this.minExplosionVolume, 1.0f - damage / this.explosionVolumeModifier);
            int time = (int)Math.min((float)this.maxExplosionTime, damage * this.explosionTimeModifier);
            if (!SoundMuteHandler.isMuting) {
                this.playSound(new ResourceLocation(this.useShortRinging ? "enhancedvisuals:ringing-short" : "enhancedvisuals:ringing"), null, (1.0f - volume) * this.maxBeepVolume);
            }
            SoundMuteHandler.startMuting(time, volume);
            VisualManager.addVisualWithShading(VisualType.blur, this.maxBlur, (int)((float)time / this.blurTimeFactor), (int)((float)time / this.blurTimeFactor), Color.WHITE);
        }
    }
}

