/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.segments.BooleanSegment;
import com.creativemd.igcm.api.segments.FloatSegment;
import com.creativemd.igcm.api.segments.IntegerSegment;
import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;

public class HeartBeatHandler
extends VisualHandler {
    private static String USE_HEALTH_PERCENTAGE = "useHealthPercentage";
    private static String HEALTH_LEVEL = "healthLevel";
    private static String HEALTH_LEVEL_PERCENTAGE = "healthLevelPercentage";
    private boolean useHealthPercentage = false;
    private int maxHealth = 6;
    private float maxHealthPercentage = 0.3f;
    private float heartBeatIntensity = 50.0f;
    private int heartBeatDuration = 5;
    private int minHeartBeatLength = 15;
    private float heartBeatTimeFactor = 100.0f;
    private float heartBeatVolume = 1.0f;
    public int effectBufferTicks;

    public HeartBeatHandler() {
        super("heart beat", "blur & bloody overlay");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.heartBeatIntensity = config.getFloat("heartBeatIntensity", this.name, this.heartBeatIntensity, 0.0f, 10000.0f, "heartbeat blur intensity");
        this.heartBeatDuration = config.getInt("heartBeatDuration", this.name, this.heartBeatDuration, 0, 10000, "heartbeat blur duration");
        this.useHealthPercentage = config.getBoolean(USE_HEALTH_PERCENTAGE, this.name, this.useHealthPercentage, "True means use the maxHealthPercentage to decide when the heartbeat effect occurs; false means use maxHealth");
        this.maxHealth = config.getInt(HEALTH_LEVEL, this.name, this.maxHealth, 0, 100, "Below or equal this amount of health enables the heartbeat effect");
        this.maxHealthPercentage = config.getFloat(HEALTH_LEVEL_PERCENTAGE, this.name, this.maxHealthPercentage, 0.0f, 1.0f, "Below or equal this percent of health enables the heartbeat effect");
        this.minHeartBeatLength = config.getInt("minHeartBeatLength", this.name, this.minHeartBeatLength, 0, 100000, "time between heartbeats = percent health remaining * heartBeatHeartFactor + minHeartBeatLength");
        this.heartBeatTimeFactor = config.getFloat("heartBeatTimeFactor", this.name, this.heartBeatTimeFactor, 0.0f, 100000.0f, "time between heartbeats = percent health remaining * heartBeatHeartFactor + minHeartBeatLength");
        this.heartBeatVolume = config.getFloat("heartBeatVolume", this.name, this.heartBeatVolume, 0.0f, 1.0f, "How loud the heart beat sounds should be");
    }

    @Override
    @Optional.Method(modid="igcm")
    public void registerConfigElements(ConfigBranch branch) {
        branch.registerElement("heartBeatIntensity", (ConfigElement)new FloatSegment("heartBeatIntensity", Float.valueOf(50.0f), 0.0f, 10000.0f).setToolTip(new String[]{"heartbeat blur intensity"}));
        branch.registerElement("heartBeatDuration", (ConfigElement)new IntegerSegment("heartBeatDuration", Integer.valueOf(5), 0, 10000).setToolTip(new String[]{"heartbeat blur duration"}));
        branch.registerElement(USE_HEALTH_PERCENTAGE, (ConfigElement)new BooleanSegment(USE_HEALTH_PERCENTAGE, Boolean.valueOf(false)).setToolTip(new String[]{"True means use the maxHealthPercentage to decide when the heartbeat effect occurs; false means use maxHealth"}));
        branch.registerElement(HEALTH_LEVEL, (ConfigElement)new IntegerSegment(HEALTH_LEVEL, Integer.valueOf(6), 0, 100).setToolTip(new String[]{"Below or equal this amount of health enables the heartbeat effect"}));
        branch.registerElement(HEALTH_LEVEL_PERCENTAGE, (ConfigElement)new FloatSegment(HEALTH_LEVEL_PERCENTAGE, Float.valueOf(0.3f), 0.0f, 1.0f).setToolTip(new String[]{"Below or equal this percent of health enables the heartbeat effect"}));
        branch.registerElement("minHeartBeatLength", (ConfigElement)new IntegerSegment("minHeartBeatLength", Integer.valueOf(15), 0, 100000).setToolTip(new String[]{"time between heartbeats = percent health remaining * heartBeatHeartFactor + minHeartBeatLength"}));
        branch.registerElement("heartBeatTimeFactor", (ConfigElement)new FloatSegment("heartBeatTimeFactor", Float.valueOf(5.0f), 0.0f, 10000.0f).setToolTip(new String[]{"time between heartbeats = percent health remaining * heartBeatHeartFactor + minHeartBeatLength"}));
        branch.registerElement("heartBeatVolume", (ConfigElement)new FloatSegment("heartBeatVolume", Float.valueOf(1.0f), 0.0f, 1.0f).setToolTip(new String[]{"How loud the heart beat sounds should be"}));
    }

    @Override
    @Optional.Method(modid="igcm")
    public void receiveConfigElements(ConfigBranch branch) {
        this.heartBeatIntensity = ((Float)branch.getValue("heartBeatIntensity")).floatValue();
        this.heartBeatDuration = (Integer)branch.getValue("heartBeatDuration");
        this.useHealthPercentage = (Boolean)branch.getValue(USE_HEALTH_PERCENTAGE);
        this.maxHealth = (Integer)branch.getValue(HEALTH_LEVEL);
        this.maxHealthPercentage = ((Float)branch.getValue(HEALTH_LEVEL_PERCENTAGE)).floatValue();
        this.minHeartBeatLength = (Integer)branch.getValue("minHeartBeatLength");
        this.heartBeatTimeFactor = ((Float)branch.getValue("heartBeatTimeFactor")).floatValue();
        this.heartBeatVolume = ((Float)branch.getValue("heartBeatVolume")).floatValue();
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        if (this.shouldHeartbeatTrigger(player)) {
            if (this.effectBufferTicks <= 0) {
                float intensity = this.getIntensity(player);
                this.resetBufferTicks(player);
                VisualManager.addVisualWithShading(VisualType.lowhealth, Math.min(0.7f, intensity), this.effectBufferTicks, this.effectBufferTicks, Color.WHITE);
                VisualManager.addVisualWithShading(VisualType.blur, Math.min(0.7f, intensity) * this.heartBeatIntensity, this.heartBeatDuration, this.heartBeatDuration, Color.WHITE);
                this.playSound(new ResourceLocation("enhancedvisuals:heartbeatOut"), new BlockPos((Entity)player), this.heartBeatVolume);
            } else if (this.effectBufferTicks == 5) {
                float intensity = this.getIntensity(player);
                this.playSound(new ResourceLocation("enhancedvisuals:heartbeatIn"), new BlockPos((Entity)player), this.heartBeatVolume);
                VisualManager.addVisualWithShading(VisualType.blur, Math.min(0.7f, intensity) * this.heartBeatIntensity, this.heartBeatDuration, this.heartBeatDuration, Color.WHITE);
            }
        }
        --this.effectBufferTicks;
    }

    private void resetBufferTicks(@Nonnull EntityPlayer player) {
        float percentHealthLeft = player.func_110143_aJ() / player.func_110138_aP();
        this.effectBufferTicks = (int)(percentHealthLeft * this.heartBeatTimeFactor + (float)this.minHeartBeatLength);
    }

    private float getIntensity(@Nonnull EntityPlayer player) {
        float percentHealthLeft = player.func_110143_aJ() / player.func_110138_aP();
        if (this.useHealthPercentage) {
            return (this.maxHealthPercentage - percentHealthLeft) * 2.0f;
        }
        return ((float)this.maxHealth - player.func_110143_aJ()) / player.func_110138_aP() * 2.0f;
    }

    private boolean shouldHeartbeatTrigger(@Nullable EntityPlayer player) {
        if (player != null) {
            if (this.useHealthPercentage) {
                float percentageHealth = player.func_110143_aJ() / player.func_110138_aP();
                return percentageHealth < this.maxHealthPercentage;
            }
            return player.func_110143_aJ() < (float)this.maxHealth;
        }
        return false;
    }
}

