/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals.types;

import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigElement;
import com.creativemd.igcm.api.segments.BooleanSegment;
import com.creativemd.igcm.api.segments.FloatSegment;
import com.sonicjumper.enhancedvisuals.addon.toughasnails.ToughAsNailsAddon;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.VisualPersistent;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualCategory;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualTypeOverlay;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualTypeShader;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualTypeSplat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VisualType {
    public static VisualType splatter = new VisualTypeSplat("splatter", true);
    public static VisualType impact = new VisualTypeSplat("impact", true);
    public static VisualType slash = new VisualTypeSplat("slash", true);
    public static VisualType pierce = new VisualTypeSplat("pierce", true);
    public static VisualType dust = new VisualTypeSplat("dust", true);
    public static VisualType fire = new VisualTypeSplat("fire", true);
    public static VisualType sand = new VisualTypeSplat("sand", true);
    public static VisualType waterS = new VisualTypeSplat("water", false);
    public static VisualType lowhealth = new VisualTypeOverlay("lowhealth", false);
    public static VisualType damaged = new VisualTypeOverlay("damaged", false);
    public static VisualType potion = new VisualTypeOverlay("potion", false);
    public static VisualType slender = new VisualTypeOverlay("slender", 50, false){

        @Override
        @SideOnly(value=Side.CLIENT)
        public VisualPersistent createPersitentVisual() {
            return new VisualPersistent(this, 0.0f);
        }
    };
    public static VisualType blur = new VisualTypeShader("blur", new ResourceLocation("shaders/post/blur.json"), false){

        @Override
        @SideOnly(value=Side.CLIENT)
        public VisualPersistent createPersitentVisual() {
            return new VisualPersistent(this, 0.0f);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void changeProperties(float intensity) {
            for (Shader mcShader : this.shaderGroup.getShaders()) {
                ShaderUniform shaderuniform = mcShader.func_148043_c().func_147991_a("Radius");
                if (shaderuniform == null) continue;
                shaderuniform.func_148090_a((float)Math.floor(intensity));
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean needsToBeRendered(float intensity) {
            return Math.floor(intensity) > 0.0;
        }
    };
    public static VisualType desaturate = new VisualTypeShader("desaturate", new ResourceLocation("shaders/post/desaturate.json"), false){

        @Override
        @SideOnly(value=Side.CLIENT)
        public VisualPersistent createPersitentVisual() {
            return new VisualPersistent(this, 1.0f);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void changeProperties(float intensity) {
            for (Shader mcShader : this.shaderGroup.getShaders()) {
                ShaderUniform shaderuniform = mcShader.func_148043_c().func_147991_a("Saturation");
                if (shaderuniform == null) continue;
                shaderuniform.func_148090_a(intensity);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean needsToBeRendered(float intensity) {
            return intensity != 1.0f;
        }
    };
    public String name;
    public final boolean isAffectedByWater;
    public final VisualCategory category;
    protected boolean enabled = true;
    public float alpha = 1.0f;

    public static void onLoad() {
        if (Loader.isModLoaded((String)"toughasnails")) {
            ToughAsNailsAddon.load();
        }
    }

    public VisualType(VisualCategory category, String name, boolean isAffectedByWater) {
        this.category = category;
        this.name = name;
        this.isAffectedByWater = isAffectedByWater;
        category.types.add(this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getConfigCat() {
        return this.name + "-type";
    }

    public void initConfig(Configuration config) {
        this.enabled = config.getBoolean("enabled", this.getConfigCat(), true, "If the effect is enabled!");
        this.alpha = config.getFloat("alpha", this.getConfigCat(), this.alpha, 0.0f, 1.0f, "");
    }

    @Optional.Method(modid="igcm")
    public ConfigBranch getConfigBranch() {
        return new ConfigBranch(this.getConfigCat(), ItemStack.field_190927_a){

            public void saveExtra(NBTTagCompound nbt) {
            }

            public void loadExtra(NBTTagCompound nbt) {
            }

            public boolean requiresSynchronization() {
                return true;
            }

            public void onRecieveFrom(Side side) {
                VisualType.this.alpha = ((Float)this.getValue("alpha")).floatValue();
                VisualType.this.enabled = (Boolean)this.getValue("enabled");
                VisualType.this.receiveConfigElements(this);
            }

            public void createChildren() {
                this.registerElement("enabled", (ConfigElement)new BooleanSegment("Enabled", Boolean.valueOf(true)).setToolTip(new String[]{"If the effect is enabled!"}));
                this.registerElement("alpha", (ConfigElement)new FloatSegment("Alpha", Float.valueOf(1.0f), 0.0f, 1.0f));
                VisualType.this.registerConfigElements(this);
            }
        };
    }

    @Optional.Method(modid="igcm")
    public abstract void registerConfigElements(ConfigBranch var1);

    @Optional.Method(modid="igcm")
    public abstract void receiveConfigElements(ConfigBranch var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void loadTextures(IResourceManager var1);

    @SideOnly(value=Side.CLIENT)
    public abstract int getVariantAmount();

    @SideOnly(value=Side.CLIENT)
    public abstract boolean isRandomized();

    @SideOnly(value=Side.CLIENT)
    public int getSize() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract boolean supportsColor();

    @SideOnly(value=Side.CLIENT)
    public abstract void render(Visual var1, TextureManager var2, ScaledResolution var3, float var4, float var5);

    @SideOnly(value=Side.CLIENT)
    public void onResize(Framebuffer buffer) {
    }

    @SideOnly(value=Side.CLIENT)
    public VisualPersistent createPersitentVisual() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract boolean needsToBeRendered(float var1);
}

