/*
 * Decompiled with CFR 0.152.
 */
package tamaized.tammodized.common.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tamaized.tammodized.registry.ITamRegistry;

public abstract class TamBlockPortal
extends BlockBreakable
implements ITamRegistry {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    private final String name;

    public TamBlockPortal(CreativeTabs tab, String n, boolean hasAxis, SoundType sound) {
        super(Material.field_151567_E, false);
        if (hasAxis) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        }
        this.func_149675_a(true);
        this.func_149715_a(0.75f);
        this.name = n;
        ModContainer container = Loader.instance().activeModContainer();
        this.func_149663_c(container == null ? this.name : container.getModId().toLowerCase() + "." + this.name);
        this.setRegistryName(this.name);
        this.func_149647_a(tab);
        this.func_149672_a(sound);
    }

    public static int getMetaForAxis(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? 1 : (axis == EnumFacing.Axis.Z ? 2 : 0);
    }

    public String getModelDir() {
        return "blocks";
    }

    @Override
    public void registerModel(ModelRegistryEvent e) {
        if (this.getRegistryName() != null) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(this.getRegistryName().func_110624_b(), this.getModelDir() + "/" + this.getRegistryName().func_110623_a()), "inventory"));
        }
    }

    @Override
    public void registerBlock(RegistryEvent.Register<Block> e) {
        e.getRegistry().register((IForgeRegistryEntry)this);
    }

    @Override
    public void registerItem(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new ItemBlock((Block)this).setRegistryName(this.name));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((meta & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public int func_176201_c(IBlockState state) {
        return TamBlockPortal.getMetaForAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    public abstract boolean tryToCreatePortal(World var1, BlockPos var2);

    public abstract void func_189540_a(IBlockState var1, World var2, BlockPos var3, Block var4, BlockPos var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void func_180655_c(IBlockState var1, World var2, BlockPos var3, Random var4);

    @SideOnly(value=Side.CLIENT)
    public abstract boolean func_176225_a(IBlockState var1, IBlockAccess var2, BlockPos var3, EnumFacing var4);

    public int func_149745_a(Random par1Random) {
        return 0;
    }
}

