/*
 * Decompiled with CFR 0.152.
 */
package tamaized.tammodized.common.fluids;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tamaized.tammodized.registry.ITamRegistry;
import tamaized.tammodized.registry.RegistryHelper;

public class TamFluidFiniteBlock
extends BlockFluidFinite
implements ITamRegistry {
    private final String name;
    private final DamageSource damageSource;
    private final int damage;

    public TamFluidFiniteBlock(CreativeTabs tab, Fluid fluid, Material material, String name, DamageSource source, int dmg) {
        super(fluid, material);
        this.name = name;
        this.damageSource = source;
        this.damage = dmg;
        ModContainer container = Loader.instance().activeModContainer();
        this.func_149663_c(container == null ? name : container.getModId().toLowerCase() + "." + name);
        this.setRegistryName(name);
        this.func_149647_a(tab);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
    }

    public String getModelDir() {
        return "fluids";
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        entityIn.func_70097_a(this.damageSource, (float)this.damage);
    }

    @Override
    public void registerBlock(RegistryEvent.Register<Block> e) {
        e.getRegistry().register((IForgeRegistryEntry)this);
    }

    @Override
    public void registerItem(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new ItemBlock((Block)this).setRegistryName(this.name));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(ModelRegistryEvent e) {
        RegistryHelper.registerFluidModel((BlockFluidBase)this);
    }
}

