/*
 * Decompiled with CFR 0.152.
 */
package tamaized.tammodized.common.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import tamaized.tammodized.common.tileentity.TamTileEntity;

public abstract class TamTileEntityInventory
extends TamTileEntity {
    private final ItemStackHandler[] inventory = this.register();

    public int getInventorySize() {
        return this.inventory.length;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void dropInventoryItems(World worldIn, BlockPos pos) {
        this.dropInventoryItems(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void dropInventoryItems(World worldIn, double x, double y, double z) {
        for (ItemStackHandler inv : this.inventory) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)worldIn, (double)x, (double)y, (double)z, (ItemStack)itemstack);
            }
        }
    }

    protected abstract ItemStackHandler[] register();

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int index = 0;
        for (ItemStackHandler slot : this.inventory) {
            String id = "itemslot_" + index;
            if (nbt.func_74764_b(id)) {
                slot.deserializeNBT((NBTTagCompound)nbt.func_74781_a(id));
            }
            ++index;
        }
        this.readNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        int index = 0;
        for (ItemStackHandler slot : this.inventory) {
            String id = "itemslot_" + index;
            nbt.func_74782_a(id, (NBTBase)slot.serializeNBT());
            ++index;
        }
        this.writeNBT(nbt);
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing enumFacing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.getCap(enumFacing) : super.getCapability(capability, enumFacing));
    }

    @Nullable
    protected abstract <T extends IItemHandler> T getCap(EnumFacing var1);

    public static class ItemStackFilterHandler
    extends ItemStackHandler {
        private final List<ItemStack> inputFilter;
        private final List<ItemStack> outputFilter;
        private final boolean insert;
        private final boolean extract;
        private List<Class<?>> inputClassFilter = new ArrayList();
        private List<Class<?>> outputClassFilter = new ArrayList();
        private int stackLimit = 64;

        public ItemStackFilterHandler(ItemStack[] input, boolean canInsert, ItemStack[] output, boolean canExtract) {
            super(1);
            this.inputFilter = Arrays.asList(input);
            this.outputFilter = Arrays.asList(output);
            this.insert = canInsert;
            this.extract = canExtract;
        }

        public ItemStackFilterHandler(Class<?>[] input, boolean canInsert, Class<?>[] output, boolean canExtract) {
            this(new ItemStack[0], canInsert, new ItemStack[0], canExtract);
            this.inputClassFilter = Arrays.asList(input);
            this.outputClassFilter = Arrays.asList(output);
        }

        public void setStackLimit(int limit) {
            this.stackLimit = limit;
        }

        public int getSlotLimit(int slot) {
            return this.stackLimit;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.insert) {
                return stack;
            }
            if (!this.inputFilter.isEmpty()) {
                for (ItemStack s : this.inputFilter) {
                    if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)s)) continue;
                    return super.insertItem(slot, stack, simulate);
                }
            } else if (!this.inputClassFilter.isEmpty()) {
                for (Class<?> s : this.inputClassFilter) {
                    if (!s.isInstance(stack.func_77973_b())) continue;
                    return super.insertItem(slot, stack, simulate);
                }
            } else {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractBypass(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.extract) {
                return ItemStack.field_190927_a;
            }
            if (!this.outputFilter.isEmpty()) {
                ItemStack stack = super.extractItem(slot, amount, true);
                for (ItemStack s : this.outputFilter) {
                    if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)s)) continue;
                    return super.extractItem(slot, amount, simulate);
                }
            } else if (!this.outputClassFilter.isEmpty()) {
                ItemStack stack = super.extractItem(slot, amount, true);
                for (Class<?> s : this.outputClassFilter) {
                    if (!s.isInstance(stack.func_77973_b())) continue;
                    return super.extractItem(slot, amount, simulate);
                }
            } else {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }
    }
}

