/*
 * Decompiled with CFR 0.152.
 */
package tamaized.tammodized.registry;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import tamaized.tammodized.common.capabilities.CapabilityList;
import tamaized.tammodized.common.capabilities.dimTracker.IDimensionCapability;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class PortalHandlerRegistry {
    private static Map<Block, TeleporterWrapper> map = new HashMap<Block, TeleporterWrapper>();

    public static void register(IBlockState state, int dimension, Class<? extends Teleporter> teleporter) {
        PortalHandlerRegistry.register(state.func_177230_c(), dimension, teleporter);
    }

    public static void register(Block block, int dimension, Class<? extends Teleporter> teleporter) {
        map.put(block, new TeleporterWrapper(dimension, teleporter));
    }

    public static TeleporterWrapper getTeleporter(IBlockState state) {
        return PortalHandlerRegistry.getTeleporter(state.func_177230_c());
    }

    public static TeleporterWrapper getTeleporter(Block block) {
        return map.get(block);
    }

    public static boolean contains(IBlockState state) {
        return PortalHandlerRegistry.contains(state.func_177230_c());
    }

    public static boolean contains(Block block) {
        return map.containsKey(block);
    }

    public static void doTeleport(IDimensionCapability cap, EntityPlayerMP player, TeleporterWrapper teleporter) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (player.field_71093_bK != teleporter.getDimension() && player.field_71093_bK != 1) {
            cap.setLastDimension(player.field_71093_bK);
            TeleportLoc port = new TeleportLoc(teleporter.getTeleporter().getConstructor(WorldServer.class).newInstance(player.field_71133_b.func_71218_a(teleporter.getDimension())));
            PortalHandlerRegistry.transferPlayerToDimension(player.field_71133_b, player, teleporter.getDimension(), port);
        } else if (player.field_71093_bK == 1) {
            cap.setLastDimension(player.field_71093_bK);
            TeleportLoc port = new TeleportLoc(teleporter.getTeleporter().getConstructor(WorldServer.class).newInstance(player.field_71133_b.func_71218_a(teleporter.getDimension())));
            PortalHandlerRegistry.transferPlayerToDimension(player.field_71133_b, player, teleporter.getDimension(), port);
            PortalHandlerRegistry.transferPlayerToDimension(player.field_71133_b, player, teleporter.getDimension(), port);
        } else {
            TeleportLoc port = new TeleportLoc(teleporter.getTeleporter().getConstructor(WorldServer.class).newInstance(player.field_71133_b.func_71218_a(cap.getLastDimension() == teleporter.getDimension() ? 0 : cap.getLastDimension())));
            PortalHandlerRegistry.transferPlayerToDimension(player.field_71133_b, player, cap.getLastDimension() == teleporter.getDimension() ? 0 : cap.getLastDimension(), port);
            cap.setLastDimension(teleporter.getDimension());
        }
    }

    private static void transferPlayerToDimension(MinecraftServer server, EntityPlayerMP player, int dimId, TeleportLoc teleporter) {
        int j = player.field_71093_bK;
        WorldServer worldserver = server.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimId;
        WorldServer worldserver1 = server.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, worldserver1.func_175659_aa(), worldserver1.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        server.func_184103_al().func_187243_f(player);
        worldserver.func_72973_f((Entity)player);
        player.field_70128_L = false;
        PortalHandlerRegistry.transferEntityToWorld((Entity)player, j, worldserver, worldserver1, teleporter);
        server.func_184103_al().func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        server.func_184103_al().func_72354_b(player, worldserver1);
        server.func_184103_al().func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, j, dimId);
    }

    private static void transferEntityToWorld(Entity p_82448_1_, int p_82448_2_, WorldServer p_82448_3_, WorldServer p_82448_4_, TeleportLoc teleporter) {
        WorldProvider pOld = p_82448_3_.field_73011_w;
        WorldProvider pNew = p_82448_4_.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double d0 = p_82448_1_.field_70165_t * moveFactor;
        double d1 = p_82448_1_.field_70161_v * moveFactor;
        float f = p_82448_1_.field_70177_z;
        p_82448_3_.field_72984_F.func_76320_a("moving");
        p_82448_3_.field_72984_F.func_76319_b();
        p_82448_3_.field_72984_F.func_76320_a("placing");
        d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
        d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
        if (p_82448_1_.func_70089_S()) {
            p_82448_1_.func_70012_b(d0, p_82448_1_.field_70163_u, d1, p_82448_1_.field_70177_z, p_82448_1_.field_70125_A);
            if (teleporter.teleporter != null) {
                teleporter.teleporter.func_180266_a(p_82448_1_, f);
            } else {
                p_82448_1_.func_70634_a((double)teleporter.pos.func_177958_n(), (double)teleporter.pos.func_177956_o(), (double)teleporter.pos.func_177952_p());
            }
            p_82448_4_.func_72838_d(p_82448_1_);
            p_82448_4_.func_72866_a(p_82448_1_, false);
        }
        p_82448_3_.field_72984_F.func_76319_b();
        p_82448_1_.func_70029_a((World)p_82448_4_);
    }

    @SubscribeEvent
    public void update(TickEvent.PlayerTickEvent e) {
        IDimensionCapability cap;
        if (e.phase == TickEvent.Phase.END && (cap = CapabilityHelper.getCap((ICapabilityProvider)e.player, CapabilityList.DIMENSION, null)) != null) {
            cap.update(e.player);
        }
    }

    private static class TeleportLoc {
        public final Teleporter teleporter;
        public final BlockPos pos;

        public TeleportLoc(Teleporter tele) {
            this.pos = null;
            this.teleporter = tele;
        }

        public TeleportLoc(BlockPos p) {
            this.teleporter = null;
            this.pos = p;
        }
    }

    private static class TeleporterWrapper {
        private final int dim;
        private final Class<? extends Teleporter> teleporter;

        public TeleporterWrapper(int dimension, Class<? extends Teleporter> t) {
            this.dim = dimension;
            this.teleporter = t;
        }

        public int getDimension() {
            return this.dim;
        }

        public Class<? extends Teleporter> getTeleporter() {
            return this.teleporter;
        }
    }
}

