/*
 * Decompiled with CFR 0.152.
 */
package magmasrc.ageofweapons.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemCustomIndustrial
extends ItemTool {
    private int breakRadius;
    private int breakDepth;
    private final float attackSpeed;
    private final float attackDamage;
    public Set EFFECTIVE_ON;
    private String harvesttool;
    private int harvestlevel;

    public ItemCustomIndustrial(int breakr, int breakd, float attackDamage, Item.ToolMaterial material, Set effectiveBlocks, String hartool, int harlevel, float attackSpeed) {
        super(material, effectiveBlocks);
        this.setHarvestLevel(hartool, harlevel);
        this.breakRadius = breakr;
        this.breakDepth = breakd;
        this.EFFECTIVE_ON = effectiveBlocks;
        this.harvesttool = hartool;
        this.harvestlevel = harlevel;
        this.attackSpeed = attackSpeed - 4.0f;
        this.attackDamage = material.func_78000_c() - 1.0f;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.attackSpeed, 0));
        }
        return multimap;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        IBlockState blockstate = player.field_70170_p.func_180495_p(pos);
        RayTraceResult mop = this.raytraceFromEntity(player.field_70170_p, player, false, 4.5);
        if (mop == null) {
            return super.onBlockStartBreak(itemstack, pos, player);
        }
        EnumFacing sideHit = mop.field_178784_b;
        int xRange = this.breakRadius;
        int yRange = this.breakRadius;
        int zRange = this.breakDepth;
        switch (sideHit) {
            case DOWN: 
            case UP: {
                yRange = this.breakDepth;
                zRange = this.breakRadius;
                break;
            }
            case NORTH: 
            case SOUTH: {
                xRange = this.breakRadius;
                zRange = this.breakDepth;
                break;
            }
            case WEST: 
            case EAST: {
                xRange = this.breakDepth;
                zRange = this.breakRadius;
            }
        }
        for (int xPos = pos.func_177958_n() - xRange; xPos <= pos.func_177958_n() + xRange; ++xPos) {
            for (int yPos = pos.func_177956_o() - yRange; yPos <= pos.func_177956_o() + yRange; ++yPos) {
                for (int zPos = pos.func_177952_p() - zRange; zPos <= pos.func_177952_p() + zRange; ++zPos) {
                    if (xPos == pos.func_177958_n() && yPos == pos.func_177956_o() && zPos == pos.func_177952_p() || super.onBlockStartBreak(itemstack, new BlockPos(xPos, yPos, zPos), player)) continue;
                    this.breakBlocks(player.field_70170_p, xPos, yPos, zPos, sideHit, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    private void breakBlocks(World world, int x, int y, int z, EnumFacing sideHit, EntityPlayer player, int refX, int refY, int refZ) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState blockstate = world.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playermp = (EntityPlayerMP)player;
        if (world.func_175623_d(pos)) {
            return;
        }
        if (block.getHarvestTool(blockstate) != this.harvesttool || block.getHarvestLevel(blockstate) > this.harvestlevel) {
            return;
        }
        if (!world.field_72995_K) {
            block.func_176208_a(world, pos, blockstate, player);
            if (block.removedByPlayer(blockstate, world, pos, player, true)) {
                block.func_176206_d(world, pos, blockstate);
                if (!player.field_71075_bZ.field_75098_d) {
                    block.func_180657_a(world, player, pos, blockstate, null, player.func_184607_cu());
                    block.func_180637_b(world, pos, block.getExpDrop(blockstate, (IBlockAccess)world, pos, 0));
                }
            }
            playermp.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        }
    }

    private RayTraceResult raytraceFromEntity(World world, EntityPlayer player, boolean b, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, b, !b, b);
    }
}

