/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.common.blocks.mechanical.BlockGearbox;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGearBoostedRail
extends BlockRailPowered {
    public static final double MOTION_CART = 0.02;
    public static final double MOTION_SCALE = 0.06;

    public BlockGearBoostedRail() {
        this.func_149711_c(0.7f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    private int getMaxPropogate() {
        return 8;
    }

    protected boolean func_176566_a(World worldIn, BlockPos pos, IBlockState state, boolean direction, int distance) {
        if (distance >= this.getMaxPropogate()) {
            return false;
        }
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        boolean flag = true;
        BlockRailBase.EnumRailDirection shape = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176568_b);
        switch (shape) {
            case NORTH_SOUTH: {
                if (direction) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case EAST_WEST: {
                if (direction) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case ASCENDING_EAST: {
                if (direction) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    flag = false;
                }
                shape = BlockRailBase.EnumRailDirection.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (direction) {
                    --i;
                    ++j;
                    flag = false;
                } else {
                    ++i;
                }
                shape = BlockRailBase.EnumRailDirection.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (direction) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    flag = false;
                }
                shape = BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (direction) {
                    ++k;
                    ++j;
                    flag = false;
                } else {
                    --k;
                }
                shape = BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            }
        }
        if (this.func_176567_a(worldIn, new BlockPos(i, j, k), direction, distance, shape)) {
            return true;
        }
        return flag && this.func_176567_a(worldIn, new BlockPos(i, j - 1, k), direction, distance, shape);
    }

    protected boolean func_176567_a(World worldIn, BlockPos pos, boolean direction, int distance, BlockRailBase.EnumRailDirection shape) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() instanceof BlockGearBoostedRail) {
            BlockRailBase.EnumRailDirection enumRailDirection = (BlockRailBase.EnumRailDirection)iblockstate.func_177229_b((IProperty)field_176568_b);
            if ((shape != BlockRailBase.EnumRailDirection.EAST_WEST || enumRailDirection != BlockRailBase.EnumRailDirection.NORTH_SOUTH && enumRailDirection != BlockRailBase.EnumRailDirection.ASCENDING_NORTH && enumRailDirection != BlockRailBase.EnumRailDirection.ASCENDING_SOUTH) && (shape != BlockRailBase.EnumRailDirection.NORTH_SOUTH || enumRailDirection != BlockRailBase.EnumRailDirection.EAST_WEST && enumRailDirection != BlockRailBase.EnumRailDirection.ASCENDING_EAST && enumRailDirection != BlockRailBase.EnumRailDirection.ASCENDING_WEST) && ((Boolean)iblockstate.func_177229_b((IProperty)field_176569_M)).booleanValue()) {
                return this.shouldBeActive(iblockstate, worldIn, pos) || this.func_176566_a(worldIn, pos, iblockstate, direction, distance + 1);
            }
        }
        return false;
    }

    protected void func_189541_b(IBlockState state, World world, BlockPos pos, Block block) {
        boolean isPowered;
        boolean poweredProperty = (Boolean)state.func_177229_b((IProperty)field_176569_M);
        boolean bl = isPowered = this.shouldBeActive(state, world, pos) || this.func_176566_a(world, pos, state, true, 0) || this.func_176566_a(world, pos, state, false, 0);
        if (poweredProperty != isPowered) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(isPowered)), 3);
            world.func_175685_c(pos.func_177977_b(), (Block)this, false);
            if (((BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176568_b)).func_177018_c()) {
                world.func_175685_c(pos.func_177984_a(), (Block)this, false);
            }
        }
    }

    private boolean shouldBeActive(IBlockState state, World world, BlockPos pos) {
        if (!(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGearbox)) {
            return false;
        }
        BlockRailBase.EnumRailDirection dir = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176568_b);
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        EnumFacing face = (EnumFacing)below.func_177229_b((IProperty)DirUtils.FACING);
        boolean correctFace = false;
        if (dir == BlockRailBase.EnumRailDirection.ASCENDING_EAST || dir == BlockRailBase.EnumRailDirection.ASCENDING_WEST || dir == BlockRailBase.EnumRailDirection.EAST_WEST) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.NORTH || face == EnumFacing.SOUTH;
        } else if (dir == BlockRailBase.EnumRailDirection.ASCENDING_NORTH || dir == BlockRailBase.EnumRailDirection.ASCENDING_SOUTH || dir == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.EAST || face == EnumFacing.WEST;
        }
        return correctFace && ((BlockGearbox)below.func_177230_c()).isActive(below);
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void deccelerateCart(EntityMinecart cart, BlockRailBase.EnumRailDirection shape, BlockPos pos) {
        double d17 = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
        if (d17 < 0.03) {
            cart.field_70159_w *= 0.0;
            cart.field_70181_x *= 0.0;
            cart.field_70179_y *= 0.0;
        } else {
            cart.field_70159_w *= 0.5;
            cart.field_70181_x *= 0.0;
            cart.field_70179_y *= 0.5;
        }
    }

    public void accelerateCart(EntityMinecart cart, BlockRailBase.EnumRailDirection shape, BlockPos pos) {
        double d15 = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
        if (d15 > 0.01) {
            cart.field_70159_w += cart.field_70159_w / d15 * 0.06;
            cart.field_70179_y += cart.field_70179_y / d15 * 0.06;
        } else if (shape == BlockRailBase.EnumRailDirection.EAST_WEST) {
            if (cart.field_70170_p.func_180495_p(pos.func_177976_e()).func_185915_l()) {
                cart.field_70159_w = 0.02;
            } else if (cart.field_70170_p.func_180495_p(pos.func_177974_f()).func_185915_l()) {
                cart.field_70159_w = -0.02;
            }
        } else if (shape == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
            if (cart.field_70170_p.func_180495_p(pos.func_177978_c()).func_185915_l()) {
                cart.field_70179_y = 0.02;
            } else if (cart.field_70170_p.func_180495_p(pos.func_177968_d()).func_185915_l()) {
                cart.field_70179_y = -0.02;
            }
        }
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!world.func_175640_z(pos.func_177977_b())) {
            BlockRailBase.EnumRailDirection shape = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176568_b);
            if (((Boolean)state.func_177229_b((IProperty)field_176569_M)).booleanValue()) {
                this.accelerateCart(cart, shape, pos);
            } else {
                this.deccelerateCart(cart, shape, pos);
            }
        }
    }
}

