/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.penalties;

import betterwithmods.common.penalties.Penalty;
import betterwithmods.common.penalties.PenaltyHandler;
import betterwithmods.common.penalties.attribute.Attribute;
import betterwithmods.common.penalties.attribute.BWMAttributes;
import betterwithmods.common.penalties.attribute.IAttributeInstance;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;

public class PenaltyHandlerRegistry
extends HashSet<PenaltyHandler<?, ?>> {
    private final Predicate<Boolean> p = Boolean::booleanValue;

    public boolean canHeal(EntityPlayer player) {
        return this.booleanAttributes(player, BWMAttributes.HEAL).allMatch(this.p);
    }

    public boolean canJump(EntityPlayer player) {
        return this.booleanAttributes(player, BWMAttributes.JUMP).allMatch(this.p);
    }

    public boolean canSprint(EntityPlayer player) {
        return this.booleanAttributes(player, BWMAttributes.SPRINT).allMatch(this.p);
    }

    public boolean canSwim(EntityPlayer player) {
        return this.booleanAttributes(player, BWMAttributes.SWIM).allMatch(this.p);
    }

    public boolean canAttack(EntityPlayer player) {
        return this.booleanAttributes(player, BWMAttributes.ATTACK).allMatch(this.p);
    }

    public boolean inPain(EntityPlayer player) {
        return this.booleanAttributes(player, BWMAttributes.PAIN).anyMatch(this.p);
    }

    public float getSpooked(EntityPlayer player) {
        return this.floatAttributes(player, BWMAttributes.SPOOKED).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float getSpeedModifier(@Nonnull EntityPlayer player) {
        return this.floatAttributes(player, BWMAttributes.SPEED).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public boolean attackedByGrue(EntityPlayer player) {
        return this.booleanAttributes(player, BWMAttributes.GRUE).anyMatch(this.p);
    }

    private Stream<Penalty<?>> handlers(@Nonnull EntityPlayer player) {
        return this.stream().map(handler -> handler.getPenalty(player)).filter(Objects::nonNull);
    }

    public Stream<Boolean> booleanAttributes(EntityPlayer player, Attribute<Boolean> attribute) {
        return this.handlers(player).map(penalty -> penalty.getBoolean(attribute)).filter(Objects::nonNull).map(IAttributeInstance::getValue);
    }

    public Stream<Float> floatAttributes(EntityPlayer player, Attribute<Float> attribute) {
        return this.handlers(player).map(penalty -> penalty.getFloat(attribute)).filter(Objects::nonNull).map(IAttributeInstance::getValue);
    }
}

