/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world;

import betterwithmods.common.BWMItems;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.BlockPlanter;
import betterwithmods.common.items.ItemFertilizer;
import betterwithmods.module.Feature;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCBonemeal
extends Feature {
    public static StackIngredient FERTILIZERS = StackIngredient.fromStacks(new ItemStack(BWMItems.FERTILIZER), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()));
    private static boolean removeBonemealRecipe;

    @Deprecated
    public static void registerFertilzier(ItemStack stack) {
        FERTILIZERS = StackIngredient.mergeStacked(Lists.newArrayList((Object[])new StackIngredient[]{FERTILIZERS, StackIngredient.fromStacks(stack)}));
    }

    @Override
    public void setupConfig() {
        removeBonemealRecipe = this.loadPropBool("Remove Bonemeal Crafting Recipe", "Removes Bonemeal from Crafting Table", true);
    }

    @Override
    public String getFeatureDescription() {
        return "Removes the ability to instant-grow crops and trees with bonemeal";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (removeBonemealRecipe) {
            BWMRecipes.removeRecipe(new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.WHITE.func_176767_b()));
        }
    }

    @SubscribeEvent
    public void onBonemeal(BonemealEvent e) {
        if (!PlayerHelper.isSurvival(e.getEntityPlayer())) {
            return;
        }
        if (!(e.getBlock().func_177230_c() instanceof BlockGrass) && !(e.getBlock().func_177230_c() instanceof BlockPlanter) && e.getBlock().func_177230_c() instanceof IGrowable) {
            IBlockState below = e.getWorld().func_180495_p(e.getPos().func_177977_b());
            below.func_177230_c().func_180649_a(e.getWorld(), e.getPos().func_177977_b(), e.getEntityPlayer());
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickBlock e) {
        ItemStack stack = e.getItemStack();
        if (!FERTILIZERS.apply(stack)) {
            return;
        }
        World world = e.getWorld();
        BlockPos pos = e.getPos();
        Block block = world.func_180495_p(pos).func_177230_c();
        EntityPlayer player = e.getEntityPlayer();
        if (block != null && block instanceof IPlantable) {
            Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (ItemFertilizer.processBlock(below, world, pos.func_177977_b()) && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        } else if (ItemFertilizer.processBlock(block, world, pos) && !player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

