/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.util.fluid.BlockLiquidWrapper;
import betterwithmods.util.fluid.FluidBlockWrapper;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidUtils {
    public static IFluidHandler getBlockFluidHandler(Fluid fluid, World world, BlockPos pos) {
        Block block = fluid.getBlock();
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, pos);
        }
        if (block instanceof BlockLiquid) {
            return new BlockLiquidWrapper((BlockLiquid)block, world, pos);
        }
        return null;
    }

    @Nullable
    public static IFluidHandler getBlockFluidHandler(World world, BlockPos blockPos, EnumFacing side) {
        IBlockState state = world.func_180495_p(blockPos);
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, blockPos);
        }
        if (block instanceof BlockLiquid) {
            return new BlockLiquidWrapper((BlockLiquid)block, world, blockPos);
        }
        state = world.func_180495_p(blockPos = blockPos.func_177972_a(side));
        block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, blockPos);
        }
        if (block instanceof BlockLiquid) {
            return new BlockLiquidWrapper((BlockLiquid)block, world, blockPos);
        }
        return null;
    }

    public static Fluid getFluidFromBlock(World world, BlockPos blockPos, EnumFacing side) {
        IFluidHandler handler = FluidUtils.getBlockFluidHandler(world, blockPos, side);
        if (handler != null) {
            return Arrays.stream(handler.getTankProperties()).map(IFluidTankProperties::getContents).filter(Objects::nonNull).map(FluidStack::getFluid).findFirst().orElse(null);
        }
        return null;
    }

    @Nonnull
    public static FluidActionResult tryPickUpFluid(@Nonnull ItemStack emptyContainer, @Nullable EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side) {
        if (emptyContainer.func_190926_b() || worldIn == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        IFluidHandler targetFluidHandler = FluidUtils.getBlockFluidHandler(worldIn, pos, side);
        if (targetFluidHandler != null) {
            return FluidUtil.tryFillContainer((ItemStack)emptyContainer, (IFluidHandler)targetFluidHandler, (int)Integer.MAX_VALUE, (EntityPlayer)playerIn, (boolean)true);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryPlaceFluid(@Nullable EntityPlayer player, World world, BlockPos pos, @Nonnull ItemStack container, FluidStack resource) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)containerCopy);
        if (containerFluidHandler != null && FluidUtils.tryPlaceFluid(player, world, pos, (IFluidHandler)containerFluidHandler, resource)) {
            return new FluidActionResult(containerFluidHandler.getContainer());
        }
        return FluidActionResult.FAILURE;
    }

    public static boolean tryPlaceFluid(@Nullable EntityPlayer player, World world, BlockPos pos, IFluidHandler fluidSource, FluidStack resource) {
        if (world == null || resource == null || pos == null) {
            return false;
        }
        Fluid fluid = resource.getFluid();
        if (fluid == null || !fluid.canBePlacedInWorld()) {
            return false;
        }
        if (fluidSource.drain(resource, false) == null) {
            return false;
        }
        IBlockState destBlockState = world.func_180495_p(pos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestNonSolid = !destMaterial.func_76220_a();
        boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (!(world.func_175623_d(pos) || isDestNonSolid || isDestReplaceable)) {
            return false;
        }
        if (world.field_73011_w.func_177500_n() && fluid.doesVaporize(resource)) {
            FluidStack result = fluidSource.drain(resource, true);
            if (result != null) {
                result.getFluid().vaporize(player, world, pos, result);
                return true;
            }
        } else {
            FluidStack result;
            IFluidHandler handler = FluidUtils.getBlockFluidHandler(fluid, world, pos);
            if (handler != null && (result = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)fluidSource, (FluidStack)resource, (boolean)true)) != null) {
                SoundEvent soundevent = resource.getFluid().getEmptySound(resource);
                world.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public static void setLiquid(World world, BlockPos pos, Block block, int level) {
        FluidUtils.setLiquid(world, pos, block, level, false);
    }

    public static void setLiquid(World world, BlockPos pos, Block block, int level, boolean force) {
        IBlockState state = world.func_180495_p(pos);
        Block existingBlock = state.func_177230_c();
        if (force || existingBlock instanceof BlockLiquid && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) > level || !state.func_185904_a().func_76224_d() && existingBlock.func_176200_f((IBlockAccess)world, pos)) {
            world.func_180501_a(pos, block.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level)), 11);
        }
    }
}

