/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;

public class LootFunctionSetRandomAbility
extends LootFunction {
    public LootFunctionSetRandomAbility(LootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        EnumRarity rarity = AbilityHelpers.getRandomRarity(rand);
        IAbilityType abilityType = AbilityHelpers.getRandomAbility(rand, rarity).get();
        IMutableAbilityStore mutableAbilityStore = (IMutableAbilityStore)stack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        mutableAbilityStore.addAbility(new Ability(abilityType, 1), true);
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<LootFunctionSetRandomAbility> {
        public Serializer() {
            super(new ResourceLocation("everlastingabilities", "set_random_ability"), LootFunctionSetRandomAbility.class);
        }

        public void serialize(JsonObject object, LootFunctionSetRandomAbility functionClazz, JsonSerializationContext serializationContext) {
        }

        public LootFunctionSetRandomAbility deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new LootFunctionSetRandomAbility(conditionsIn);
        }
    }
}

