/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.hud;

import WayofTime.bloodmagic.client.hud.ElementRegistry;
import WayofTime.bloodmagic.client.hud.element.HUDElement;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiEditHUD
extends GuiScreen {
    private static final int LINE_COLOR = 0x2D2D2D;
    private final GuiScreen parent;
    private final Map<ResourceLocation, Vector2f> currentOverrides = Maps.newHashMap();
    private HUDElement dragged;
    public boolean changes;

    public GuiEditHUD(GuiScreen parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b((GuiButton)new GuiButtonExt(0, this.field_146294_l / 2 - 155, this.field_146295_m - 30, 70, 20, I18n.func_135052_a((String)"gui.bloodmagic.toggle", (Object[])new Object[0])){
            {
                this.field_146124_l = false;
            }
        });
        this.func_189646_b((GuiButton)new GuiButtonExt(1, this.field_146294_l / 2 - 75, this.field_146295_m - 30, 70, 20, I18n.func_135052_a((String)"gui.bloodmagic.default", (Object[])new Object[0])));
        this.func_189646_b((GuiButton)new GuiButtonExt(2, this.field_146294_l / 2 + 5, this.field_146295_m - 30, 70, 20, I18n.func_135052_a((String)"gui.bloodmagic.save", (Object[])new Object[0])));
        this.func_189646_b((GuiButton)new GuiButtonExt(3, this.field_146294_l / 2 + 90, this.field_146295_m - 30, 70, 20, I18n.func_135052_a((String)"gui.bloodmagic.cancel", (Object[])new Object[0])));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        for (HUDElement element : ElementRegistry.getElements()) {
            if (this.dragged == element) continue;
            ResourceLocation key = ElementRegistry.getKey(element);
            Vector2f position = this.currentOverrides.getOrDefault(key, ElementRegistry.getPosition(key));
            int xPos = (int)(resolution.func_78327_c() * (double)position.x);
            int yPos = (int)(resolution.func_78324_d() * (double)position.y);
            this.drawWithBox(resolution, element, partialTicks, xPos, yPos);
        }
        if (this.dragged != null) {
            Point bounded = this.getBoundedDrag(resolution, mouseX, mouseY);
            this.drawWithBox(resolution, this.dragged, partialTicks, bounded.x, bounded.y);
        }
    }

    public boolean func_73868_f() {
        return true;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.dragged != null) {
            return;
        }
        HUDElement element = this.getHoveredElement(mouseX, mouseY);
        if (element == null) {
            return;
        }
        if (clickedMouseButton == 0) {
            this.dragged = element;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.dragged != null) {
            ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
            Point bounded = this.getBoundedDrag(resolution, mouseX, mouseY);
            float xPos = (float)((double)bounded.x / resolution.func_78327_c());
            float yPos = (float)((double)bounded.y / resolution.func_78324_d());
            this.currentOverrides.put(ElementRegistry.getKey(this.dragged), new Vector2f(xPos, yPos));
            this.changes = true;
            this.dragged = null;
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                Minecraft.func_71410_x().func_147108_a(this.parent);
                break;
            }
            case 1: {
                this.currentOverrides.clear();
                ElementRegistry.resetPos();
                this.changes = false;
                break;
            }
            case 2: {
                ElementRegistry.save(this.currentOverrides);
                Minecraft.func_71410_x().func_147108_a(this.parent);
                break;
            }
            case 3: {
                this.currentOverrides.clear();
                Minecraft.func_71410_x().func_147108_a(this.parent);
            }
        }
    }

    @Nullable
    public HUDElement getHoveredElement(int mouseX, int mouseY) {
        for (HUDElement element : ElementRegistry.getElements()) {
            ResourceLocation key = ElementRegistry.getKey(element);
            Vector2f position = this.currentOverrides.getOrDefault(key, ElementRegistry.getPosition(key));
            ScaledResolution resolution = new ScaledResolution(this.field_146297_k);
            int xPos = (int)(resolution.func_78327_c() * (double)position.x);
            int yPos = (int)(resolution.func_78324_d() * (double)position.y);
            if (mouseX < xPos || mouseX > xPos + element.getWidth() || mouseY < yPos || mouseY > yPos + element.getHeight()) continue;
            return element;
        }
        return null;
    }

    protected Point getBoundedDrag(ScaledResolution resolution, int mouseX, int mouseY) {
        int drawY;
        int drawX = mouseX - this.dragged.getWidth() / 2;
        if (drawX + this.dragged.getWidth() >= resolution.func_78326_a()) {
            drawX = resolution.func_78326_a() - this.dragged.getWidth();
        }
        if (drawX < 0) {
            drawX = 0;
        }
        if ((drawY = mouseY - this.dragged.getHeight() / 2) + this.dragged.getHeight() >= resolution.func_78328_b()) {
            drawY = resolution.func_78328_b() - this.dragged.getHeight();
        }
        if (drawY < 0) {
            drawY = 0;
        }
        return new Point(drawX, drawY);
    }

    protected void drawWithBox(ScaledResolution resolution, HUDElement element, float partialTicks, int drawX, int drawY) {
        int color = ElementRegistry.getColor(ElementRegistry.getKey(element));
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.func_73728_b(drawX, drawY, drawY + element.getHeight() - 1, color);
        this.func_73728_b(drawX + element.getWidth() - 1, drawY, drawY + element.getHeight() - 1, color);
        this.func_73730_a(drawX, drawX + element.getWidth() - 1, drawY, color);
        this.func_73730_a(drawX, drawX + element.getWidth() - 1, drawY + element.getHeight() - 1, color);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        element.draw(resolution, partialTicks, drawX, drawY);
        GlStateManager.func_179090_x();
    }
}

