/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.core.patcher;

import java.util.Map;
import net.ilexiconn.llibrary.client.event.ApplyRenderRotationsEvent;
import net.ilexiconn.llibrary.client.event.PlayerModelEvent;
import net.ilexiconn.llibrary.client.event.PlayerViewDistanceEvent;
import net.ilexiconn.llibrary.client.event.RenderArmEvent;
import net.ilexiconn.llibrary.server.core.api.LLibraryCoreAPI;
import net.ilexiconn.llibrary.server.core.plugin.LLibraryPlugin;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LLibraryHooks {
    public static float prevRenderViewDistance = 4.0f;

    @SideOnly(value=Side.CLIENT)
    public static void addRemoteLocalizations(String language, Map<String, String> properties) {
        LLibraryHooks.getAPI().addRemoteLocalizations(language, properties);
    }

    @SideOnly(value=Side.CLIENT)
    public static void provideStackContext(ItemStack stack) {
        if (stack != null) {
            LLibraryHooks.getAPI().provideStackContext(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void providePerspectiveContext(ItemCameraTransforms.TransformType transforms) {
        LLibraryHooks.getAPI().providePerspectiveContext(transforms);
    }

    public static long getTickRate() {
        return LLibraryHooks.getAPI().getTickRate();
    }

    private static LLibraryCoreAPI getAPI() {
        if (LLibraryPlugin.api == null) {
            LLibraryPlugin.LOGGER.warn("Unable to call Core API! It has not been initialized yet!");
            return new LLibraryCoreAPI.Fallback();
        }
        return LLibraryPlugin.api;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderArmPre(RenderPlayer renderPlayer, AbstractClientPlayer player, EnumHandSide side) {
        ModelPlayer modelPlayer = renderPlayer.func_177087_b();
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderArmEvent.Pre(player, renderPlayer, modelPlayer, side))) {
            if (side == EnumHandSide.LEFT) {
                modelPlayer.field_178724_i.field_78806_j = false;
                modelPlayer.field_178734_a.field_78806_j = false;
            } else {
                modelPlayer.field_178723_h.field_78806_j = false;
                modelPlayer.field_178732_b.field_78806_j = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderArmPost(RenderPlayer renderPlayer, AbstractClientPlayer player, EnumHandSide side) {
        ModelPlayer modelPlayer = renderPlayer.func_177087_b();
        MinecraftForge.EVENT_BUS.post((Event)new RenderArmEvent.Post(player, renderPlayer, modelPlayer, side));
        if (side == EnumHandSide.LEFT) {
            modelPlayer.field_178724_i.field_78806_j = true;
            modelPlayer.field_178734_a.field_78806_j = true;
        } else {
            modelPlayer.field_178723_h.field_78806_j = true;
            modelPlayer.field_178732_b.field_78806_j = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelBiped assignModel(RenderPlayer renderPlayer, ModelBiped model, boolean smallArms) {
        PlayerModelEvent.Assign event = new PlayerModelEvent.Assign(renderPlayer, model, smallArms);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModel();
    }

    @SideOnly(value=Side.CLIENT)
    public static void setRotationAngles(ModelBiped model, Entity entity, float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, float scale) {
        if (entity instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerModelEvent.SetRotationAngles(model, (EntityPlayer)entity, limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, scale));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderModel(ModelBiped model, Entity entity, float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, float scale) {
        if (entity instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerModelEvent.Render(model, (EntityPlayer)entity, limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, scale));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void constructModel(ModelPlayer model) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerModelEvent.Construct((ModelBiped)model));
    }

    @SideOnly(value=Side.CLIENT)
    public static float getViewDistance(Entity entity, float partialTicks) {
        float distance;
        PlayerViewDistanceEvent event = new PlayerViewDistanceEvent(entity, partialTicks, 4.0);
        MinecraftForge.EVENT_BUS.post((Event)event);
        prevRenderViewDistance = distance = (float)event.getNewViewDistance();
        return distance;
    }

    @SideOnly(value=Side.CLIENT)
    public static void applyRotationsPre(RenderLivingBase<EntityLivingBase> renderer, EntityLivingBase entity, float partialTicks) {
        MinecraftForge.EVENT_BUS.post((Event)new ApplyRenderRotationsEvent.Pre(renderer, entity, partialTicks));
    }

    @SideOnly(value=Side.CLIENT)
    public static void applyRotationsPost(RenderLivingBase<EntityLivingBase> renderer, EntityLivingBase entity, float partialTicks) {
        MinecraftForge.EVENT_BUS.post((Event)new ApplyRenderRotationsEvent.Post(renderer, entity, partialTicks));
    }
}

