/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.block.groves;

import epicsquid.mysticallib.block.BlockBase;
import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.particle.particles.ParticleLeafArc;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.network.fx.MessageOvergrowthEffectFX;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGroveStone
extends BlockBase {
    public static final PropertyEnum<Half> HALF = PropertyEnum.func_177709_a((String)"half", Half.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", facing -> facing == EnumFacing.NORTH || facing == EnumFacing.EAST);
    public static final PropertyBool VALID = PropertyBool.func_177716_a((String)"valid");

    public BlockGroveStone(@Nonnull String name) {
        super(Material.field_151576_e, SoundType.field_185851_d, 2.5f, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VALID, (Comparable)Boolean.valueOf(false)).func_177226_a(HALF, (Comparable)((Object)Half.BOTTOM)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149675_a(true);
        this.field_149783_u = true;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            if (state.func_177229_b(HALF) == Half.TOP) {
                return new AxisAlignedBB(0.15, 0.0, 0.2, 0.85, 0.7, 0.8);
            }
            return new AxisAlignedBB(0.15, 0.0, 0.2, 0.85, 1.0, 0.8);
        }
        if (state.func_177229_b(HALF) == Half.TOP) {
            return new AxisAlignedBB(0.2, 0.0, 0.15, 0.8, 0.7, 0.85);
        }
        return new AxisAlignedBB(0.2, 0.0, 0.15, 0.8, 1.0, 0.85);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VALID, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a(HALF, (Comparable)((Object)Half.fromInt((meta & 7) >> 1))).func_177226_a((IProperty)FACING, (Comparable)(meta >> 3 == 0 ? EnumFacing.NORTH : EnumFacing.EAST));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH ? 0 : 1) << 2 ^ ((Half)((Object)state.func_177229_b(HALF))).ordinal()) << 1 ^ ((Boolean)state.func_177229_b((IProperty)VALID) != false ? 1 : 0);
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, VALID, FACING});
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            return false;
        }
        IBlockState up = worldIn.func_180495_p(pos.func_177984_a());
        IBlockState upup = worldIn.func_180495_p(pos.func_177984_a().func_177984_a());
        return up.func_177230_c() != this && upup.func_177230_c() != this && super.func_176196_c(worldIn, pos) && up.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a()) && upup.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a().func_177984_a());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)Half.MIDDLE)).func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        worldIn.func_175656_a(pos.func_177984_a().func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)Half.TOP)).func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing f = EnumFacing.func_176733_a((double)placer.field_70177_z).func_176734_d();
        f = f == EnumFacing.NORTH || f == EnumFacing.SOUTH || f == EnumFacing.DOWN || f == EnumFacing.UP ? EnumFacing.NORTH : EnumFacing.EAST;
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)Half.BOTTOM)).func_177226_a((IProperty)FACING, (Comparable)f);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        IBlockState downdown = worldIn.func_180495_p(pos.func_177977_b().func_177977_b());
        IBlockState up = worldIn.func_180495_p(pos.func_177984_a());
        IBlockState upup = worldIn.func_180495_p(pos.func_177984_a().func_177984_a());
        if (down.func_177230_c() == this) {
            worldIn.func_175698_g(pos.func_177977_b());
        }
        if (downdown.func_177230_c() == this) {
            worldIn.func_175698_g(pos.func_177977_b().func_177977_b());
        }
        if (up.func_177230_c() == this) {
            worldIn.func_175698_g(pos.func_177984_a());
        }
        if (upup.func_177230_c() == this) {
            worldIn.func_175698_g(pos.func_177984_a());
        }
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180645_a(world, pos, state, random);
        if (!GeneralConfig.EnableGroveStoneEnvironment) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)VALID)).booleanValue()) {
            return;
        }
        if (random.nextInt(GeneralConfig.GroveStoneChance) == 1) {
            int effectsCount = 1 + random.nextInt(1);
            List positions = Util.getBlocksWithinRadius((World)world, (BlockPos)pos.func_177977_b(), (float)4.0f, (float)5.0f, (float)4.0f, p -> {
                if (world.func_175623_d(p.func_177984_a())) {
                    IBlockState s = world.func_180495_p(p);
                    return s.func_185904_a() == Material.field_151577_b;
                }
                return false;
            });
            Collections.shuffle(positions);
            for (BlockPos p2 : positions) {
                if (effectsCount <= 0) break;
                IBlockState s = world.func_180495_p(p2);
                Block b = s.func_177230_c();
                if (s.func_185904_a() != Material.field_151577_b || !world.func_175623_d(p2.func_177984_a().func_177984_a())) continue;
                switch (random.nextInt(50)) {
                    case 0: {
                        if (b.canSustainPlant(s, (IBlockAccess)world, p2, EnumFacing.UP, (IPlantable)Blocks.field_150398_cm)) {
                            Blocks.field_150398_cm.func_176491_a(world, p2.func_177984_a(), BlockDoublePlant.EnumPlantType.ROSE, 3);
                            break;
                        }
                    }
                    case 1: {
                        if (b.canSustainPlant(s, (IBlockAccess)world, p2, EnumFacing.UP, (IPlantable)Blocks.field_150398_cm)) {
                            Blocks.field_150398_cm.func_176491_a(world, p2.func_177984_a(), BlockDoublePlant.EnumPlantType.SUNFLOWER, 3);
                            break;
                        }
                    }
                    case 2: 
                    case 3: {
                        if (b.canSustainPlant(s, (IBlockAccess)world, p2, EnumFacing.UP, (IPlantable)Blocks.field_150398_cm)) {
                            Blocks.field_150398_cm.func_176491_a(world, p2.func_177984_a(), BlockDoublePlant.EnumPlantType.GRASS, 3);
                            break;
                        }
                    }
                    case 4: {
                        if (b.canSustainPlant(s, (IBlockAccess)world, p2, EnumFacing.UP, (IPlantable)Blocks.field_150398_cm)) {
                            Blocks.field_150398_cm.func_176491_a(world, p2.func_177984_a(), BlockDoublePlant.EnumPlantType.PAEONIA, 3);
                            break;
                        }
                    }
                    case 5: {
                        if (b.canSustainPlant(s, (IBlockAccess)world, p2, EnumFacing.UP, (IPlantable)Blocks.field_150398_cm)) {
                            Blocks.field_150398_cm.func_176491_a(world, p2.func_177984_a(), BlockDoublePlant.EnumPlantType.SYRINGA, 3);
                            break;
                        }
                    }
                    default: {
                        if (b.canSustainPlant(s, (IBlockAccess)world, p2, EnumFacing.UP, (IPlantable)Blocks.field_150329_H)) {
                            world.func_180501_a(p2.func_177984_a(), Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS), 3);
                            break;
                        }
                        return;
                    }
                }
                MessageOvergrowthEffectFX message = new MessageOvergrowthEffectFX((double)p2.func_177958_n() + 0.5, (double)p2.func_177956_o() + 0.3, (double)p2.func_177952_p() + 0.5);
                PacketHandler.sendToAllTracking((IMessage)message, (World)world, (BlockPos)p2.func_177984_a());
                --effectsCount;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (((Boolean)stateIn.func_177229_b((IProperty)VALID)).booleanValue() && stateIn.func_177229_b(HALF) == Half.MIDDLE) {
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    if (i > -2 && i < 2 && j == -1) {
                        j = 2;
                    }
                    if (rand.nextInt(32) != 0) continue;
                    for (int k = 0; k <= 1 && worldIn.func_175623_d(pos.func_177982_a(i / 2, 0, j / 2)); ++k) {
                        ClientProxy.particleRenderer.spawnParticle(worldIn, Util.getLowercaseClassName(ParticleLeafArc.class), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, ((double)i + rand.nextDouble() - 0.05) * 0.04, -1.0E-4, ((double)((float)j + rand.nextFloat()) - 0.05) * 0.04, new double[]{100.0, 0.9098039215686274 + rand.nextDouble() * 0.05, 0.6549019607843137, 0.43529411764705883, 0.385, 0.117 + rand.nextDouble() * 0.05, 1.0, rand.nextDouble() + 0.5, rand.nextDouble() * 2.0});
                    }
                }
            }
        }
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return BlockFaceShape.UNDEFINED;
        }
        return super.func_193383_a(worldIn, state, pos, face);
    }

    public static enum Half implements IStringSerializable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String func_176610_l() {
            switch (this) {
                case TOP: {
                    return "top";
                }
                case MIDDLE: {
                    return "middle";
                }
            }
            return "bottom";
        }

        public static Half fromInt(int x) {
            for (Half half : Half.values()) {
                if (half.ordinal() != x) continue;
                return half;
            }
            return BOTTOM;
        }
    }
}

