/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.command;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.ritual.conditions.ConditionStandingStones;
import epicsquid.roots.ritual.conditions.ConditionTrees;
import epicsquid.roots.ritual.conditions.ICondition;
import epicsquid.roots.tileentity.TileEntityBonfire;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandRitual
extends CommandBase {
    public String func_71517_b() {
        return "ritual";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/ritual <ritual name>";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("ritual");
    }

    public int func_82362_a() {
        return 2;
    }

    private ItemStack resolveStack(Ingredient ing) {
        return ing.func_193365_a()[0].func_77946_l();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayerMP && args.length != 0) {
            RitualBase ritual;
            EntityPlayerMP player = (EntityPlayerMP)sender;
            String ritualName = args[0];
            if (!ritualName.startsWith("ritual")) {
                ritualName = "ritual_" + ritualName;
            }
            if ((ritual = RitualRegistry.getRitual(ritualName)) == null || ritual.isDisabled()) {
                player.func_145747_a((ITextComponent)new TextComponentString("Invalid or disabled ritual: " + args[0]));
                return;
            }
            WorldServer world = player.func_71121_q();
            BlockPos pos = player.func_180425_c();
            world.func_175656_a(pos.func_177977_b(), Blocks.field_150486_ae.func_176223_P());
            world.func_175656_a(pos, ModBlocks.bonfire.func_176223_P());
            TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos.func_177977_b());
            TileEntityBonfire bonfire = (TileEntityBonfire)world.func_175625_s(pos);
            bonfire.setLastRitualUsed(ritual);
            int i = 0;
            for (Ingredient ing : ritual.getIngredients()) {
                bonfire.inventory.setStackInSlot(i, this.resolveStack(ing));
                for (int j = i * 5; j < i * 5 + 5; ++j) {
                    ItemStack stack = this.resolveStack(ing);
                    stack.func_190920_e(stack.func_77976_d());
                    chest.func_70299_a(j, stack);
                }
                ++i;
            }
            ItemStack flint = new ItemStack(Items.field_151033_d);
            if (!player.func_191521_c(flint)) {
                ItemUtil.spawnItem((World)world, (BlockPos)pos, (ItemStack)flint);
            }
            int runePos = 0;
            for (ICondition condition : ritual.getConditions()) {
                if (condition instanceof ConditionStandingStones) {
                    ConditionStandingStones stones = (ConditionStandingStones)condition;
                    for (i = 0; i < stones.getAmount(); ++i) {
                        BlockPos base = pos.func_177982_a(runePos + i + 1, 0, 0);
                        for (int j = 0; j < stones.getHeight(); ++j) {
                            world.func_175656_a(base.func_177982_a(0, j, 0), j == stones.getHeight() - 1 ? ModBlocks.chiseled_runestone.func_176223_P() : ModBlocks.runestone.func_176223_P());
                        }
                    }
                    runePos += stones.getAmount();
                    continue;
                }
                if (!(condition instanceof ConditionTrees)) continue;
                ConditionTrees trees = (ConditionTrees)condition;
                BlockPlanks.EnumType type = trees.getTreeType();
                for (i = 0; i < trees.getAmount(); ++i) {
                    BlockPos base = pos.func_177982_a(0, 1, i + 1);
                    if (type.func_176839_a() >= 4) {
                        world.func_175656_a(base, Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)type));
                        continue;
                    }
                    world.func_175656_a(base, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)type));
                }
            }
        }
    }
}

