/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.RitualConfig;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.network.fx.MessageRampantLifeInfusionFX;
import epicsquid.roots.recipe.AnimalHarvestFishRecipe;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.util.types.WeightedRegistry;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityRitualAnimalHarvest
extends EntityRitualBase {
    protected static Random random = new Random();
    protected static final DataParameter<Integer> lifetime = EntityDataManager.func_187226_a(EntityRitualAnimalHarvest.class, (DataSerializer)DataSerializers.field_187192_b);
    private ObjectOpenHashSet<Class<? extends EntityLivingBase>> harvestClasses;
    private static Method getLootTable = null;

    public EntityRitualAnimalHarvest(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_animal_harvest.getDuration() + 20));
        this.harvestClasses = ModRecipes.getAnimalHarvestClasses();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        int curLifetime = (Integer)this.func_184212_Q().func_187225_a(lifetime);
        this.func_184212_Q().func_187227_b(lifetime, (Object)(curLifetime - 1));
        this.func_184212_Q().func_187217_b(lifetime);
        if ((Integer)this.func_184212_Q().func_187225_a(lifetime) < 0) {
            this.func_70106_y();
        }
        if (this.field_70173_aa % 110 == 0) {
            for (int i = 0; i < 5 && !this.doHarvest(); ++i) {
            }
        }
    }

    public boolean doHarvest() {
        List entityList = Util.getEntitiesWithinRadius((World)this.field_70170_p, entity -> this.harvestClasses.contains(entity.getClass()), (BlockPos)this.func_180425_c(), (float)15.0f, (float)10.0f, (float)15.0f);
        if (RitualConfig.animalHarvestDoFish) {
            List waterSourceBlocks = Util.getBlocksWithinRadius((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)15.0f, (float)10.0f, (float)15.0f, p -> {
                IBlockState state = this.field_70170_p.func_180495_p(p);
                return state.func_185904_a() == Material.field_151586_h && state.func_177227_a().contains(BlockLiquid.field_176367_b) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
            });
            WeightedRegistry<AnimalHarvestFishRecipe> recipes = new WeightedRegistry<AnimalHarvestFishRecipe>((Collection<AnimalHarvestFishRecipe>)ModRecipes.getFishRecipes());
            if (!(recipes.isEmpty() || waterSourceBlocks.isEmpty() || this.field_70146_Z.nextInt(5) != 0 && !entityList.isEmpty())) {
                AnimalHarvestFishRecipe recipe = recipes.getRandomItem(this.field_70146_Z);
                BlockPos pos = (BlockPos)waterSourceBlocks.get(this.field_70146_Z.nextInt(waterSourceBlocks.size()));
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack stack = recipe.getItemStack().func_77946_l();
                    stack.func_190920_e(3 + Math.max(0, this.field_70146_Z.nextInt(3) - 2));
                    ItemUtil.spawnItem((World)this.field_70170_p, (BlockPos)pos.func_177982_a(0, 1, 0), (ItemStack)stack);
                }
                PacketHandler.sendToAllTracking((IMessage)new MessageRampantLifeInfusionFX(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), (Entity)this);
                return true;
            }
        }
        if (entityList.isEmpty()) {
            return false;
        }
        EntityLiving entity2 = (EntityLiving)entityList.get(random.nextInt(entityList.size()));
        boolean didDrops = false;
        if (!this.field_70170_p.field_72995_K) {
            entity2.captureDrops = true;
            entity2.capturedDrops.clear();
            EntityRitualAnimalHarvest.dropLoot(entity2, true);
            entity2.captureDrops = false;
            if (!ForgeHooks.onLivingDrops((EntityLivingBase)entity2, (DamageSource)DamageSource.field_76377_j, (ArrayList)entity2.capturedDrops, (int)0, (boolean)false)) {
                for (EntityItem item : entity2.capturedDrops) {
                    item.field_70181_x = 0.0;
                    item.field_70159_w = 0.0;
                    item.field_70179_y = 0.0;
                    this.field_70170_p.func_72838_d((Entity)item);
                    didDrops = true;
                }
            }
        }
        if (didDrops) {
            entity2.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 30, 0, false, false));
        }
        return didDrops;
    }

    @Override
    public DataParameter<Integer> getLifetime() {
        return lifetime;
    }

    public static ResourceLocation getLootTable(EntityLiving entity) {
        if (getLootTable == null) {
            getLootTable = ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"func_184647_J", ResourceLocation.class, (Class[])new Class[0]);
            getLootTable.setAccessible(true);
        }
        try {
            return (ResourceLocation)getLootTable.invoke((Object)entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    public static void dropLoot(EntityLiving entity, boolean player) {
        ResourceLocation resourcelocation = entity.field_184659_bA;
        if (resourcelocation == null) {
            resourcelocation = EntityRitualAnimalHarvest.getLootTable(entity);
        }
        if (resourcelocation != null) {
            LootTable loottable = entity.field_70170_p.func_184146_ak().func_186521_a(resourcelocation);
            entity.field_184659_bA = null;
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)entity.field_70170_p));
            LootContext context = new LootContext(random.nextInt(6) == 0 ? 1.0f : 0.0f, (WorldServer)entity.field_70170_p, entity.field_70170_p.func_184146_ak(), (Entity)entity, (EntityPlayer)fakePlayer, DamageSource.field_76377_j);
            for (ItemStack itemstack : loottable.func_186462_a(entity.field_184653_bB == 0L ? entity.field_70146_Z : new Random(entity.field_184653_bB), context)) {
                entity.func_70099_a(itemstack, 0.0f);
            }
        }
    }
}

