/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import epicsquid.roots.recipe.TransmutationRecipe;
import epicsquid.roots.util.types.WorldPosStatePredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class TransmutationAboveLiquidRecipe
extends TransmutationRecipe {
    private final Fluid below;
    private boolean water = false;
    private boolean lava = false;

    public TransmutationAboveLiquidRecipe(ResourceLocation name, Block startBlock, ItemStack endState, Fluid below) {
        super(name, startBlock, endState, null);
        this.below = below;
        this.water = below == FluidRegistry.WATER;
        this.lava = below == FluidRegistry.LAVA;
    }

    public TransmutationAboveLiquidRecipe(ResourceLocation name, Block startBlock, IBlockState endState, Fluid below) {
        super(name, startBlock, endState, null);
        this.below = below;
        this.water = below == FluidRegistry.WATER;
        this.lava = below == FluidRegistry.LAVA;
    }

    public TransmutationAboveLiquidRecipe(ResourceLocation name, IBlockState startState, IBlockState endState, Fluid below) {
        super(name, startState, endState, null);
        this.below = below;
        this.water = below == FluidRegistry.WATER;
        this.lava = below == FluidRegistry.LAVA;
    }

    public TransmutationAboveLiquidRecipe(ResourceLocation name, IBlockState startState, ItemStack endState, Fluid below) {
        super(name, startState, endState, null);
        this.below = below;
        this.water = below == FluidRegistry.WATER;
        this.lava = below == FluidRegistry.LAVA;
    }

    @Override
    public WorldPosStatePredicate getCondition() {
        return (t, u, v) -> {
            IBlockState down = t.func_180495_p(u.func_177977_b());
            Block block = down.func_177230_c();
            if ((this.water || this.lava) && block instanceof BlockLiquid) {
                if ((block == Blocks.field_150353_l || block == Blocks.field_150356_k) && this.lava) {
                    return true;
                }
                if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && this.water) {
                    return true;
                }
            } else if (block instanceof IFluidBlock) {
                return ((IFluidBlock)block).getFluid() == this.below;
            }
            return false;
        };
    }
}

