/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.entity.ritual.EntityRitualSummonCreatures;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.recipe.SummonCreatureRecipe;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionItems;
import epicsquid.roots.ritual.conditions.ConditionValidSummon;
import epicsquid.roots.tileentity.TileEntityOffertoryPlate;
import epicsquid.roots.util.RitualUtil;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class RitualSummonCreatures
extends RitualBase {
    public RitualSummonCreatures(String name, int duration, boolean disabled) {
        super(name, duration, disabled);
        this.addCondition(new ConditionItems(new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151110_aK), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151014_N)));
        this.addCondition(new ConditionValidSummon());
        this.setIcon(ModItems.ritual_summon_creatures);
        this.setColor(TextFormatting.DARK_PURPLE);
        this.setBold(true);
    }

    @Override
    public EntityRitualBase doEffect(World world, BlockPos pos) {
        EntityRitualSummonCreatures entity = (EntityRitualSummonCreatures)this.spawnEntity(world, pos, EntityRitualSummonCreatures.class);
        if (!world.field_72995_K) {
            List<TileEntityOffertoryPlate> plates = RitualUtil.getNearbyOfferingPlates(world, pos);
            List<ItemStack> plateItems = RitualUtil.getItemsFromNearbyPlates(plates);
            SummonCreatureRecipe recipe = ModRecipes.findSummonCreatureEntry(plateItems);
            if (recipe != null) {
                for (TileEntityOffertoryPlate plate : plates) {
                    plate.removeItem();
                }
            }
            ItemStack essence = ItemStack.field_190927_a;
            if (recipe == null) {
                for (TileEntityOffertoryPlate plate : plates) {
                    ItemStack stack = plate.getHeldItem();
                    if (stack.func_77973_b() != ModItems.life_essence) continue;
                    essence = stack;
                    plate.removeItem();
                    break;
                }
            }
            if (entity != null) {
                entity.setEssence(essence);
                entity.setSummonRecipe(recipe);
            }
        }
        return entity;
    }
}

