/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual.conditions;

import epicsquid.mysticallib.util.ListUtil;
import epicsquid.roots.ritual.conditions.ICondition;
import epicsquid.roots.tileentity.TileEntityBonfire;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ConditionItems
implements ICondition {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    public ConditionItems(Object ... stacks) {
        for (Object stack : stacks) {
            if (stack instanceof Ingredient) {
                this.ingredients.add((Ingredient)stack);
                continue;
            }
            if (!(stack instanceof ItemStack)) continue;
            this.ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)stack}));
        }
    }

    @Override
    public boolean checkCondition(TileEntityBonfire tile, @Nullable EntityPlayer player) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < tile.inventory.getSlots(); ++i) {
            stacks.add(tile.inventory.extractItem(i, 1, true));
        }
        return ListUtil.matchesIngredients(stacks, this.ingredients);
    }

    @Override
    public ITextComponent failMessage() {
        return new TextComponentTranslation("roots.ritual.condition.items", new Object[0]);
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }
}

