/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual.conditions;

import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.ritual.conditions.ICondition;
import epicsquid.roots.tileentity.TileEntityBonfire;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ConditionStandingStones
implements ICondition {
    private final int height;
    private final int amount;

    public ConditionStandingStones(int height, int amount) {
        this.height = height;
        this.amount = amount;
    }

    public int getHeight() {
        return this.height;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public boolean checkCondition(TileEntityBonfire tile, EntityPlayer player) {
        return this.getStandingStones(tile.func_145831_w(), tile.func_174877_v(), this.height) >= this.amount;
    }

    @Override
    @Nullable
    public ITextComponent failMessage() {
        return new TextComponentTranslation("roots.ritual.condition.standing_stones", new Object[]{new TextComponentTranslation("roots.ritual.condition.standing_stones.types", new Object[]{this.getAmount(), this.getHeight()})});
    }

    protected int getStandingStones(World world, BlockPos pos, int height) {
        Block material = ModBlocks.runestone;
        int threeHighCount = 0;
        for (int i = -9; i <= 10; ++i) {
            for (int j = -9; j <= 10; ++j) {
                IBlockState state = world.func_180495_p(pos.func_177982_a(i, height - 1, j));
                if (state.func_177230_c() != ModBlocks.chiseled_runestone) continue;
                boolean stoneFound = true;
                for (int y = height - 1; y > 0; --y) {
                    if (world.func_180495_p(pos.func_177982_a(i, 1, j)).func_177230_c() == material) continue;
                    stoneFound = false;
                }
                if (!stoneFound) continue;
                ++threeHighCount;
            }
        }
        return threeHighCount;
    }
}

