/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.SpellConfig;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.network.fx.MessageSanctuaryBurstFX;
import epicsquid.roots.network.fx.MessageSanctuaryRingFX;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.modules.SpellModule;
import epicsquid.roots.util.EntityUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellSanctuary
extends SpellBase {
    public static String spellName = "spell_sanctuary";
    public static SpellSanctuary instance = new SpellSanctuary(spellName);
    private static Set<String> entitiesBlackList = new HashSet<String>();

    public SpellSanctuary(String name) {
        super(name, TextFormatting.DARK_PURPLE, 0.8156863f, 0.0627451f, 0.3137255f, 0.8784314f, 0.1254902f, 0.5647059f);
        this.castType = SpellBase.EnumCastType.CONTINUOUS;
        this.cooldown = 0;
        this.addCost(HerbRegistry.getHerbByName("pereskia"), 0.125);
        this.addCost(HerbRegistry.getHerbByName("wildroot"), 0.125);
        this.addIngredients(new ItemStack((Item)Items.field_179565_cj), new ItemStack(ModItems.pereskia), new ItemStack(Items.field_151117_aB), new ItemStack(ModItems.bark_spruce), new ItemStack(ModItems.wildroot));
    }

    @Override
    public boolean cast(EntityPlayer player, List<SpellModule> modules) {
        List entities = Util.getEntitiesWithinRadius((World)player.field_70170_p, Entity.class, (BlockPos)player.func_180425_c(), (float)4.0f, (float)5.0f, (float)4.0f);
        if (entities.size() > 0) {
            for (Entity e : entities) {
                if (e.func_110124_au().compareTo(player.func_110124_au()) == 0 || !(e instanceof IProjectile) && !EntityUtil.isHostile(e) || entitiesBlackList.contains(EntityList.func_191301_a((Entity)e).toString()) || !(Math.pow(e.field_70165_t - player.field_70165_t, 2.0) + Math.pow(e.field_70163_u - player.field_70163_u, 2.0) + Math.pow(e.field_70161_v - player.field_70161_v, 2.0) < 9.0)) continue;
                e.field_70159_w = 0.125 * (e.field_70165_t - player.field_70165_t);
                e.field_70181_x = 0.125 * (e.field_70163_u - player.field_70163_u);
                e.field_70179_y = 0.125 * (e.field_70161_v - player.field_70161_v);
                e.field_70133_I = true;
                if (e.func_82150_aj()) continue;
                PacketHandler.sendToAllTracking((IMessage)new MessageSanctuaryBurstFX(e.field_70165_t, e.field_70163_u + (double)(0.6f * e.func_70047_e()), e.field_70161_v), (Entity)e);
            }
        }
        if (player.field_70173_aa % 2 == 0) {
            PacketHandler.sendToAllTracking((IMessage)new MessageSanctuaryRingFX(player.field_70165_t, player.field_70163_u + 0.875, player.field_70161_v), (Entity)player);
        }
        return true;
    }

    static {
        entitiesBlackList.addAll(Arrays.asList(SpellConfig.spellFeaturesCategory.sanctuaryEntitiesBlacklist));
    }
}

