/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class EntityUtil {
    private static Set<ResourceLocation> forcedFriendly = new HashSet<ResourceLocation>();
    private static Set<ResourceLocation> forcedHostile = new HashSet<ResourceLocation>();

    public static boolean isHostile(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return false;
        }
        ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
        if (forcedFriendly.contains(rl)) {
            return false;
        }
        if (forcedHostile.contains(rl)) {
            return true;
        }
        if (entity instanceof IMob) {
            return true;
        }
        if (entity.isCreatureType(EnumCreatureType.MONSTER, false)) {
            return true;
        }
        return entity instanceof IProjectile;
    }

    public static boolean isFriendly(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return false;
        }
        ResourceLocation rl = EntityList.func_191301_a((Entity)entity);
        if (forcedFriendly.contains(rl)) {
            return true;
        }
        if (forcedHostile.contains(rl)) {
            return false;
        }
        if (entity instanceof EntityAnimal) {
            return true;
        }
        if (entity.isCreatureType(EnumCreatureType.AMBIENT, false) || entity.isCreatureType(EnumCreatureType.WATER_CREATURE, false) || entity.isCreatureType(EnumCreatureType.CREATURE, false)) {
            return true;
        }
        return !EntityUtil.isHostile(entity);
    }

    public static boolean isHostile(Entity entity, EntityPlayer player) {
        EntityLiving living;
        if (EntityUtil.isHostile(entity)) {
            return true;
        }
        return entity instanceof EntityLiving && (living = (EntityLiving)entity).func_70638_az() == player;
    }
}

